% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data-class.R
\docType{class}
\name{DataOrdinal-class}
\alias{DataOrdinal-class}
\alias{.DataOrdinal}
\alias{DataOrdinal}
\alias{.DefaultDataOrdinal}
\title{\code{DataOrdinal}}
\usage{
DataOrdinal(
  x = numeric(),
  y = integer(),
  ID = integer(),
  cohort = integer(),
  doseGrid = numeric(),
  placebo = FALSE,
  yCategories = c(`No DLT` = 0L, DLT = 1L),
  ...
)

.DefaultDataOrdinal()
}
\arguments{
\item{x}{(\code{numeric})\cr the doses for the patients.}

\item{y}{(\code{integer})\cr the vector of toxicity events (0 or 1).
You can also supply \code{numeric} vectors, but these will then be converted to
\code{integer} internally.}

\item{ID}{(\code{integer})\cr unique patient IDs.
You can also supply \code{numeric} vectors, but these will then be converted to
\code{integer} internally.}

\item{cohort}{(\code{integer})\cr the cohort (non-negative sorted) indices.
You can also supply \code{numeric} vectors, but these will then be converted to
\code{integer} internally.}

\item{doseGrid}{(\code{numeric})\cr all possible doses.}

\item{placebo}{(\code{flag})\cr if \code{TRUE} the first dose level
in the \code{doseGrid} is considered as placebo.}

\item{yCategories}{(named \code{integer})\cr the names and codes for the
toxicity categories used in the data.  Category labels are taken from the
names of the vector.  The names of the vector must be unique and its values
must be sorted and take the values 0, 1, 2, ...}

\item{...}{not used.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{DataOrdinal}} is a class for ordinal toxicity data.
It inherits from \code{\link{GeneralData}} and it describes toxicity responses on an
ordinal rather than binary scale.
}
\details{
The \code{cohort} can be missing if and only if \code{placebo} is equal to
\code{FALSE}.
}
\note{
This class has been implemented as a sibling of the existing \code{Data} class
(rather than as a parent or child) to minimise the risk of unintended side
effects on existing classes and methods.

The default setting for the \code{yCategories} slot replicates the behaviour
of the existing \code{Data} class.

Typically, end users will not use the \code{.DefaultDataOrdinal()} function.
}
\examples{
DataOrdinal(
  x = c(10, 20, 30, 40, 50, 50, 50, 60, 60, 60),
  y = as.integer(c(0, 0, 0, 0, 0, 1, 0, 0, 1, 2)),
  ID = 1L:10L,
  cohort = as.integer(c(1:4, 5, 5, 5, 6, 6, 6)),
  doseGrid = c(seq(from = 10, to = 100, by = 10)),
  yCategories = c("No tox" = 0L, "Sub-tox AE" = 1L, "DLT" = 2L),
  placebo = FALSE
)
}
