% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{NextBestOrdinal-class}
\alias{NextBestOrdinal-class}
\alias{.NextBestOrdinal}
\alias{NextBestOrdinal}
\alias{.DefaultNextBestOrdinal}
\title{\code{NextBestOrdinal}}
\usage{
NextBestOrdinal(grade, rule)

.DefaultNextBestOrdinal()
}
\arguments{
\item{grade}{(\code{numeric})\cr see slot definition.}

\item{rule}{(\code{NextBest})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{NextBestOrdinal}} is the class for applying a standard \code{NextBest} rule to
the results of an ordinal CRM trial.
}
\section{Slots}{

\describe{
\item{\code{grade}}{(\code{integer})\cr the toxicity grade to which the \code{rule} should be
applied.}

\item{\code{rule}}{(\code{NextBest})\cr the standard \code{NextBest} rule to be applied}
}}

\note{
Typically, end users will not use the \code{.DefaultNextBestOrdinal()} function.
}
\examples{
NextBestOrdinal(
  grade = 1L,
  rule = NextBestMTD(
    0.25,
    function(mtd_samples) {
      quantile(mtd_samples, probs = 0.25)
    }
  )
)
}
