% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{OneParLogNormalPrior-class}
\alias{OneParLogNormalPrior-class}
\alias{.OneParLogNormalPrior}
\alias{OneParLogNormalPrior}
\alias{.DefaultOneParLogNormalPrior}
\title{\code{OneParLogNormalPrior}}
\usage{
OneParLogNormalPrior(skel_probs, dose_grid, sigma2)

.DefaultOneParLogNormalPrior()
}
\arguments{
\item{skel_probs}{(\code{numeric})\cr skeleton prior probabilities. This is a vector
of unique and sorted probability values between 0 and 1.}

\item{dose_grid}{(\code{numeric})\cr dose grid. It must be must be a sorted vector
of the same length as \code{skel_probs}.}

\item{sigma2}{(\code{number})\cr prior variance of log power parameter alpha.}
}
\value{
an instance of the \code{OneParLogNormalPrior} class
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{OneParLogNormalPrior}} is the class for a standard CRM with a normal prior on
the log power parameter for the skeleton prior probabilities.
}
\section{Slots}{

\describe{
\item{\code{skel_fun}}{(\code{function})\cr function to calculate the prior DLT probabilities.}

\item{\code{skel_fun_inv}}{(\code{function})\cr inverse function of \code{skel_fun}.}

\item{\code{skel_probs}}{(\code{numeric})\cr skeleton prior probabilities. This is a vector
of unique and sorted probability values between 0 and 1.}

\item{\code{sigma2}}{(\code{number})\cr prior variance of log power parameter alpha.}
}}

\examples{
my_model <- OneParLogNormalPrior(
  skel_probs = seq(from = 0.1, to = 0.9, length = 5),
  dose_grid = 1:5,
  sigma2 = 2
)
}
\seealso{
\code{\link{ModelLogNormal}}.
}
