% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Design-class.R
\docType{class}
\name{RuleDesignOrdinal-class}
\alias{RuleDesignOrdinal-class}
\alias{.RuleDesignOrdinal}
\alias{RuleDesignOrdinal}
\alias{.DefaultRuleDesignOrdinal}
\title{\code{RuleDesignOrdinal}}
\usage{
RuleDesignOrdinal(next_best, cohort_size, data, starting_dose)

.DefaultRuleDesignOrdinal()
}
\arguments{
\item{next_best}{(\code{NextBestOrdinal})\cr see slot definition.}

\item{cohort_size}{(\code{CohortSize})\cr see slot definition.}

\item{data}{(\code{DataOrdinal})\cr see slot definition.}

\item{starting_dose}{(\code{number})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{RuleDesignOrdinal}} is the class for rule-based designs. The difference between
this class and the \code{\link{DesignOrdinal}} class is that \code{\link{RuleDesignOrdinal}}
does not contain \code{model}, \code{stopping} and \code{increments} slots.
}
\details{
Please note that the cohort size rules need to be wrapped into
the corresponding \link{CohortSizeOrdinal} class, before a successful evaluation of the
corresponding methods can take place. Note also that these wrappers cannot be nested,
i.e., you cannot have a \link{CohortSizeOrdinal} inside another \link{CohortSizeOrdinal}
(which also would not make sense) because it would not be clear which event grade to use
for the methods calculation. However, multiple rules can be combined using the operators
defined, e.g.,
\code{CohortSizeMin(list(CohortSizeOrdinal(1L, rule1), CohortSizeOrdinal(2L, rule2)))}.
}
\section{Slots}{

\describe{
\item{\code{next_best}}{(\code{NextBestOrdinal})\cr how to find the next best dose.}

\item{\code{cohort_size}}{(\code{CohortSize})\cr rules for the cohort sizes.}

\item{\code{data}}{(\code{DataOrdinal})\cr specifies dose grid, any previous data, etc.}

\item{\code{starting_dose}}{(\code{number})\cr the starting dose, it must lie on the dose
grid in \code{data}.}
}}

\note{
Typically, end users will not use the \code{.DefaultRuleDesignOrdinal()} function.
}
\examples{
RuleDesignOrdinal(
  next_best = NextBestOrdinal(
    1L,
    NextBestMTD(
      target = 0.25,
      derive = function(x) median(x, na.rm = TRUE)
    )
  ),
  cohort_size = CohortSizeOrdinal(1L, CohortSizeConst(size = 3L)),
  data = DataOrdinal(doseGrid = c(5, 10, 15, 25, 35, 50, 80)),
  starting_dose = 5
)
}
