% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{CohortSizeParts-class}
\alias{CohortSizeParts-class}
\alias{.CohortSizeParts}
\alias{CohortSizeParts}
\alias{.DefaultCohortSizeParts}
\title{\code{CohortSizeParts}}
\usage{
CohortSizeParts(cohort_sizes)

.DefaultCohortSizeParts()
}
\arguments{
\item{cohort_sizes}{(\code{numeric})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{CohortSizeParts}} is the class for cohort size that changes for the second
part of the dose escalation. It works only in conjunction with \code{\link{DataParts}}
objects.
}
\section{Slots}{

\describe{
\item{\code{cohort_sizes}}{(\code{integer})\cr a vector of length two with two sizes, one for
part 1, and one for part 2 respectively.}
}}

\note{
Typically, end users will not use the \code{.DefaultCohortSizeParts()} function.
}
\examples{
# Part 1 cohort size = 1, Part 2 cohort size = 3.
my_size <- CohortSizeParts(cohort_sizes = c(1, 3))
}
