% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_primaryEndpointResults.R
\name{f.primaryEndpointResults}
\alias{f.primaryEndpointResults}
\title{Calculate details of a study's primary endpoint analysis and testing}
\usage{
f.primaryEndpointResults(df = NULL)
}
\arguments{
\item{df}{data frame such as from \link{dbGetFieldsIntoDf}. If `NULL`,
prints fields needed in `df` for calculating this trial concept, which can
be used with \link{dbGetFieldsIntoDf}.}
}
\value{
data frame with columns `_id` and new columns:
`.primaryEndpointFirstPvalue` (discarding any inequality indicator, e.g. <=),
`.primaryEndpointFirstPmethod` (normalised string, e.g. chisquared),
`.primaryEndpointFirstPsize` (number included in test, across assignment groups).
}
\description{
Trial concept calculated: Calculates several results-related elements of
the primary analysis of the primary endpoint. Requires loading
results-related information.
For CTIS and ISRCTN, such information is not available in structured format.
Recommended to be combined with .controlType, .sampleSize etc. for analyses.
}
\examples{
# fields needed
f.primaryEndpointResults()

# apply trial concept when creating data frame
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials", flags = RSQLite::SQLITE_RO)
trialsDf <- dbGetFieldsIntoDf(
  calculate = "f.primaryEndpointResults",
  con = dbc)
trialsDf

}
