% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endian.R
\name{aperm_array_to_vector}
\alias{aperm_array_to_vector}
\title{Permute an R array to a linear vector of data}
\usage{
aperm_array_to_vector(x, dst, flipy = FALSE)
}
\arguments{
\item{x}{array}

\item{dst}{Specification of destination dimensions in the order of presentation
in the source data. Character vector which contains 3 strings:
'planes', 'rows', 'cols'.  The order of these strings determines
the order of output in the linear data. Currently, "planes" must always
be the final element.}

\item{flipy}{flip the array vertically. Default: FALSE}
}
\value{
vector
}
\description{
Permute an R array to a linear vector of data
}
\examples{
# create a small RGBA array in R with each 
# plane of the array holding a different colour channel
  arr <- array(c(paste0('r', 1:6), 
                 paste0('g', 1:6), 
                 paste0('b', 1:6),
                 paste0('a', 1:6)), c(2, 3, 4))
arr

# A very common C ordering is packaged RGBA data in column major format
# i.e. Iterate over: planes, then columns, then rows
# i.e. 
#    start at first element
#    (plane1, plane2, plane3, plane4)
#    go to next column
#    (plane1, plane2, plane3, plane4)
#    go to next column
#    ...
#    when last column is done
#    do to next row

# Convert to packed RGBA in column-major format
vec <- aperm_array_to_vector(arr, dst = c('planes', 'cols', 'rows'))
vec

# To convert column-major packed RGBA to an R array, use the same ordering
# for the dimensions, but also need to specify length along each dimension
aperm_vector_to_array(vec, src = c(planes = 4, cols = 3, rows = 2))
}
\seealso{
Other data permutation functions: 
\code{\link{aperm_vector_to_array}()},
\code{\link{flip_endian}()}
}
\concept{data permutation functions}
