% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_time_period_system_levels}
\alias{cvd_time_period_system_levels}
\title{Time periods and system levels}
\usage{
cvd_time_period_system_levels()
}
\value{
tibble of time periods and associated system levels
}
\description{
Returns all available time periods along with the systems levels included
in each time period.
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#*Proposed*-\%2FtimePeriod\%2FsystemLevels}{Time period system levels}
}
\examples{
# get a tibble of all periods and levels
periods_levels <- cvd_time_period_system_levels()

# see which levels are available for the latest period
periods_levels |>
  dplyr::filter(TimePeriodID == max(TimePeriodID)) |>
  dplyr::select(TimePeriodID, TimePeriodName, SystemLevelID, SystemLevelName)
}
\seealso{
\code{\link[=cvd_time_period_list]{cvd_time_period_list()}}
}
