% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_indicator_metric_area_breakdown}
\alias{cvd_indicator_metric_area_breakdown}
\title{Compare metric performance for an area against national and system-level peers}
\usage{
cvd_indicator_metric_area_breakdown(time_period_id, area_id, metric_id)
}
\arguments{
\item{time_period_id}{Integer (required). The ID of the reporting period. Use \code{\link[=cvd_time_period_list]{cvd_time_period_list()}} to find valid IDs.}

\item{area_id}{Integer (required). The ID of the NHS area to anchor the comparison. Use \code{\link[=cvd_area_list]{cvd_area_list()}} or \code{\link[=cvd_area_search]{cvd_area_search()}} to find valid IDs.}

\item{metric_id}{Integer (required). The ID of the metric to retrieve. Use \code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}} or \code{\link[=cvd_indicator_data]{cvd_indicator_data()}} to find valid IDs.}
}
\value{
A tibble comparing metric performance for a specified NHS area and the national aggregate. Each row represents one area (local or national) and includes the following columns:
\describe{
\item{NationalLevel}{Character. Indicates whether the row represents national-level data ("Y" for national, "N" for local).}
\item{SystemLevelID}{Integer. Identifier for the system level (e.g., 1 = England, 4 = PCN).}
\item{SystemLevelMedian}{Numeric. Median value for the metric across all areas in the system level.}
\item{SystemLevelName}{Character. Name of the system level (e.g., "England", "PCN").}
\item{SystemLevelOrder}{Integer. Display order for the system level.}
\item{TargetLabel}{Character. Descriptive label for the target threshold (e.g., "Upper threshold for QOF").}
\item{TargetValue}{Numeric. Target value to be achieved (e.g., 95).}
\item{AreaCode}{Character. Code for the NHS area (e.g., "U60510" for a PCN, "E92000001" for England).}
\item{AreaID}{Integer. Unique identifier for the NHS area.}
\item{AreaName}{Character. Name of the NHS area (e.g., "Salford South East PCN").}
\item{Value}{Numeric. Final calculated value for the metric in the area.}
}
If no data is available for the given parameters, a tibble describing the error is returned.
}
\description{
Returns a tibble showing the performance of a specified metric for a given NHS area, alongside national-level data and other areas within the same system level (e.g., PCNs within an ICB). This function powers the Area Breakdown chart in CVDPREVENT reporting.
}
\details{
The output includes:
\itemize{
\item Metric values for the selected area
\item Comparison with national performance (AreaID = 1)
\item Peer areas within the same system level
\item Target thresholds (if defined)
}

This function is useful for:
\itemize{
\item Benchmarking local performance against national and peer averages
\item Identifying variation within a system level
\item Supporting targeted improvement and equity analysis
}

To find valid \code{metric_id} values, use \code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}} or \code{\link[=cvd_indicator_data]{cvd_indicator_data()}}.
For valid \code{area_id} values, use \code{\link[=cvd_area_list]{cvd_area_list()}} or \code{\link[=cvd_area_search]{cvd_area_search()}}.
For valid \code{time_period_id} values, use \code{\link[=cvd_time_period_list]{cvd_time_period_list()}}.
}
\note{
This function may take longer than 5 seconds to complete due to API response time.
}
\section{API Documentation}{

See the \href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Findicator\%2FmetricAreaBreakdown\%2F\%3Cmetric_ID\%3E}{CVDPREVENT API documentation: Indicator metric area breakdown}
}

\examples{
\donttest{
# Compare performance for metric ID 128 in time period 17 for
# Salford South East PCN (area ID 705)
cvd_indicator_metric_area_breakdown(
  metric_id = 128,
  time_period_id = 17,
  area_id = 705
) |>
  dplyr::select(SystemLevelName, AreaID, AreaName, Value)
}

}
\seealso{
\code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}} to browse available metrics,
\code{\link[=cvd_area_list]{cvd_area_list()}} and \code{\link[=cvd_area_search]{cvd_area_search()}} to find valid area IDs,
\code{\link[=cvd_time_period_list]{cvd_time_period_list()}} to explore reporting periods,
\code{\link[=cvd_indicator_metric_systemlevel_comparison]{cvd_indicator_metric_systemlevel_comparison()}} for peer-level comparisons,
\code{\link[=cvd_indicator_metric_timeseries]{cvd_indicator_metric_timeseries()}} for longitudinal analysis,
\code{\link[=cvd_indicator_priority_groups]{cvd_indicator_priority_groups()}} for grouped indicator metadata
}
