% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_indicator_priority_groups}
\alias{cvd_indicator_priority_groups}
\title{List all indicator priority groups}
\usage{
cvd_indicator_priority_groups()
}
\value{
A tibble with one row per indicator / priority group containing the following columns:
\describe{
\item{PriorityGroup}{Character. High-level grouping label for the indicator (e.g., "CKD", "Prevalence", "ABC").}
\item{AxisCharacter}{Character. Symbol used to represent the metric axis (e.g., "\%").}
\item{FormatDisplayName}{Character. Display format for the metric (e.g., "Proportion \%", "Rate per 10,000 patients").}
\item{HighestPriorityNotificationType}{Character. Notification priority level, if applicable (e.g., "Blue"). Often blank.}
\item{IndicatorCode}{Character. Unique code for the indicator (e.g., "CVDP002AF").}
\item{IndicatorFormatID}{Integer. Internal ID for the indicator's format type.}
\item{IndicatorID}{Integer. Unique identifier for the indicator.}
\item{IndicatorName}{Character. Full descriptive name of the indicator.}
\item{MetricID}{Integer. Unique identifier for the specific metric instance.}
\item{NotificationCount}{Integer. Count of notifications associated with the indicator.}
\item{PathwayGroupID}{Integer. Unique identifier for the clinical pathway group.}
\item{PathwayGroupName}{Character. Name of the clinical pathway group (e.g., "Chronic Kidney Disease", "Hypertension").}
\item{PriorityGroupDisplayOrder}{Integer. Display order for the priority group within its pathway.}
\item{PriorityGroupID}{Integer. Unique identifier for the priority group.}
\item{QuestionGroupName}{Character. Thematic label for the indicator's clinical focus (e.g., "Diagnosis", "Management", "Monitoring").}
}
If no priority groups are found, returns a tibble describing the error.
}
\description{
Retrieves a tibble of indicator priority groups from the CVDPREVENT API. Priority groups reflect high-level clinical, operational or policy themes (such as "Inequalities" or "NHS Long Term Plan") and provide a way to cluster or filter multiple indicators for reporting and analytics.
}
\details{
Use this function to provide grouping / filtering options for dashboards or reports, or to explore which indicator themes are tracked in CVDPREVENT. Typically, you will select the priority group's name and ID for grouping or filtering tasks.
}
\note{
This function may take longer than 5 seconds to complete due to API response time.
}
\section{API Documentation}{

See the \href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Findicator\%2FpriorityGroup}{CVDPREVENT API documentation: Indicator priority groups}
}

\examples{
\donttest{
# List all available priority group display names and their IDs
cvd_indicator_priority_groups() |>
  dplyr::select(PriorityGroupID, PriorityGroup)

# Preview group names for a sidebar filter in a dashboard
groups <- cvd_indicator_priority_groups()
unique(groups$PriorityGroup)
}

}
\seealso{
\code{\link[=cvd_indicator_list]{cvd_indicator_list()}}, \code{\link[=cvd_indicator_group]{cvd_indicator_group()}}, \code{\link[=cvd_area_list]{cvd_area_list()}}, \code{\link[=cvd_time_period_list]{cvd_time_period_list()}}
}
