% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{simulate_traces_one_cond}
\alias{simulate_traces_one_cond}
\title{Simulate Traces for One Conditions}
\usage{
simulate_traces_one_cond(drift_dm_obj, k, one_cond, add_x, sigma)
}
\arguments{
\item{drift_dm_obj}{a model of type \link{drift_dm}}

\item{k}{a single numeric, the number of traces to simulate}

\item{one_cond}{a single character string, specifying which condition shall
be simulated}

\item{add_x}{a single logical, indicating if starting values shall be added
or not. Sometimes, when visualizing the model, one does not want to have
the starting values.}

\item{sigma}{a single numeric, to override the "sigma" in
\link{prms_solve}}
}
\value{
An array of size k times \code{nt + 1}. The array becomes an object of type
\code{traces_dm}, which allows for easier printing with \link{print.traces_dm}.
Furthermore, each object has the additional attributes:
\itemize{
\item "t_vec" -> the time space from 0 to t_max
\item "mu_vals" -> the drift rate values by mu_fun
\item "b_vals" -> the boundary values by b_fun
\item "samp_x" -> the values of the starting points (which are always added to
the traces in the array.
\item "add_x" -> boolean, indicating if the starting values were added or not
\item "orig_model_class" -> the class label of the original model
\item "orig_prms" -> the parameters with which the traces were simulated (for
the respective condition)
\item "b_coding" -> the boundary coding
\item "prms_solve" -> the solver settings with which the traces were simulated
}
}
\description{
The function simulates traces with forward Euler. It is the backend function
to \code{simulate_traces}.
}
