% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_add_data_frames.R
\name{prep_add_data_frames}
\alias{prep_add_data_frames}
\title{Add data frames to the pre-loaded / cache data frame environment}
\usage{
prep_add_data_frames(..., data_frame_list = list())
}
\arguments{
\item{...}{data frames, if passed with names, these will be the names
of these tables in the data frame environment. If not, then the
names in the calling environment will be used.}

\item{data_frame_list}{a named list with data frames. Also these will be
added and names will be handled as for the \code{...}
argument.}
}
\value{
\link{data.frame} \verb{invisible(the cache environment)}
}
\description{
These can be referred to by their names, then, wherever \code{dataquieR} expects
a \link{data.frame} -- just pass a character instead. If this character is not
found, \code{dataquieR} would additionally look for files with the name and for
\code{URLs}. You can also refer to specific sheets of a workbook or specific
object from an \code{RData} by appending a pipe symbol and its name. A second
pipe symbol allows to extract certain columns from such sheets (but
they will remain data frames).
}
\seealso{
\link{prep_load_workbook_like_file}

\link{prep_get_data_frame}

Other data-frame-cache: 
\code{\link{prep_get_data_frame}()},
\code{\link{prep_list_dataframes}()},
\code{\link{prep_load_folder_with_metadata}()},
\code{\link{prep_load_workbook_like_file}()},
\code{\link{prep_purge_data_frame_cache}()},
\code{\link{prep_remove_from_cache}()}
}
\concept{data-frame-cache}
