% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_datacite.R, R/datacite.R
\name{as_datacite}
\alias{as_datacite}
\alias{datacite}
\alias{is.datacite}
\alias{is.datacite.datacite}
\alias{print.datacite}
\title{Create a Bibentry Object with DataCite Metadata Fields}
\source{
\itemize{
\item \href{https://support.datacite.org/docs/schema-mandatory-properties-v43}{DataCite 4.3 Mandatory Properties}
\item \href{https://support.datacite.org/docs/schema-optional-properties-v43}{DataCite 4.3 Optional Properties}
}
}
\usage{
as_datacite(x, type = "bibentry", ...)

datacite(
  Title,
  Creator,
  Identifier = NULL,
  Publisher = NULL,
  PublicationYear = NULL,
  Subject = subject_create(term = "data sets", subjectScheme =
    "Library of Congress Subject Headings (LCSH)", schemeURI =
    "https://id.loc.gov/authorities/subjects.html", valueURI =
    "http://id.loc.gov/authorities/subjects/sh2018002256"),
  Type = "Dataset",
  Contributor = NULL,
  Date = ":tba",
  DateList = NULL,
  Language = NULL,
  AlternateIdentifier = ":unas",
  RelatedIdentifier = ":unas",
  Format = ":tba",
  Version = "0.1.0",
  Rights = ":tba",
  Description = ":tba",
  Geolocation = ":unas",
  FundingReference = ":unas"
)

is.datacite(x)

\method{is.datacite}{datacite}(x)

\method{print}{datacite}(x, ...)
}
\arguments{
\item{x}{An object that is tested if it has a class "datacite".}

\item{type}{A DataCite 4.4 metadata can be returned as:
\code{"list"}, \code{"dataset_df"}, \code{"bibentry"} (default), or \code{"ntriples"}.}

\item{...}{Optional parameters to add to a \code{datacite} object.
For example, \code{author = person("Jane", "Doe")} adds an author if
\code{type = "dataset_df"}.}

\item{Title}{The name(s) by which the resource is known. Similar to
\href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/elements11/title/}{dct:title}.}

\item{Creator}{One or more \code{\link[utils:person]{utils::person()}} objects describing the main
authors or contributors responsible for creating the resource.}

\item{Identifier}{A persistent identifier (e.g., DOI or URI). May refer to a
specific version or all versions of the resource.}

\item{Publisher}{The name of the organization that holds, publishes, or
distributes the resource. Required by DataCite. See \code{\link[=publisher]{publisher()}}.}

\item{PublicationYear}{The year of public availability (in \code{YYYY} format).
See \code{\link[=publication_year]{publication_year()}}.}

\item{Subject}{A topic, keyword, or classification term. See \code{\link[=subject]{subject()}} and
\code{\link[=subject_create]{subject_create()}} for structured vocabularies.}

\item{Type}{The resource type. Defaults to \code{"Dataset"} for general use. See
\href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/elements11/type/}{dcm:type}.}

\item{Contributor}{An individual or institution that contributed to the
development, distribution, or curation of the resource.}

\item{Date}{A date in \code{"YYYY"}, \code{"YYYY-MM-DD"} or ISO datetime format.
Can also be a \link{Date} or \link{POSIXct} object.}

\item{DateList}{A list of multiple dates. Currently not supported.}

\item{Language}{Language code as per IETF BCP 47 / ISO 639-1. See \code{\link[=language]{language()}}.}

\item{AlternateIdentifier}{Optional local or secondary identifier. Defaults
to \code{":unas"}.}

\item{RelatedIdentifier}{Related resources (e.g., prior versions, papers).
Defaults to \code{":unas"}.}

\item{Format}{A technical format (e.g., \code{"application/pdf"}, \code{"text/csv"}).}

\item{Version}{A free-text version string (e.g., \code{"1.0.0"}). Defaults to
\code{"0.1.0"}. See \code{\link[=version]{version()}}.}

\item{Rights}{Licensing or usage restrictions for the resource. Defaults to
\code{":tba"}. See \code{\link[=rights]{rights()}}.}

\item{Description}{Free-text summary or additional information. Defaults to
\code{":tba"}.}

\item{Geolocation}{Geographic location covered or referenced by the resource.
See \code{\link[=geolocation]{geolocation()}}.}

\item{FundingReference}{Information about funding or financial support.
Defaults to \code{":unas"}. Structured funding metadata not yet implemented.}
}
\value{
\code{as_datacite(x, type)} returns the DataCite bibliographical metadata
of \code{x} either as a list, a bibentry object, an N-Triples text serialisation
or a dataset_df object.

A \code{\link[utils:bibentry]{utils::bibentry()}} object with DataCite-compliant fields. Use
\code{\link[=as_datacite]{as_datacite()}} to extract the metadata as a list or bibentry object.

\code{is.datacite(x)} returns a logical values (if the object
\code{x} is of class \code{datacite}).
}
\description{
Constructs a bibliographic metadata record conforming to the
\href{https://schema.datacite.org/}{DataCite Metadata Schema}. The resulting
object is stored as a modified \code{\link[utils:bibentry]{utils::bibentry()}} enriched with structured
Dublin Core and DataCite-compliant metadata.
}
\details{
DataCite is a leading non-profit organization that provides persistent
identifiers (DOIs) for research data and other research outputs. Members of
the research community use DataCite to register datasets with globally
resolvable metadata for citation and discovery.

This function sets \code{"Dataset"} as the default resource type. The \code{Size}
attribute (e.g., bytes, pages, etc.) is automatically added if available.
}
\examples{
datacite(
  Title = "Growth of Orange Trees",
  Creator = c(
    person(
      given = "N.R.",
      family = "Draper",
      role = "cre",
      comment = c(VIAF = "http://viaf.org/viaf/84585260")
    ),
    person(
      given = "H",
      family = "Smith",
      role = "cre"
    )
  ),
  Publisher = "Wiley",
  Date = 1998,
  Language = "en"
)

# Extract bibliographic metadata
as_datacite(orange_df)

# As a list
as_datacite(orange_df, "list")

}
\seealso{
Learn more in the vignette:
\href{https://dataset.dataobservatory.eu/articles/bibrecord.html}{\code{bibrecord}}

Other bibrecord functions: 
\code{\link{as_dublincore}()},
\code{\link{bibrecord}()}
}
\concept{bibrecord functions}
