% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodelayer.R
\name{layer_node}
\alias{layer_node}
\title{NODE/ODTs Layer}
\usage{
layer_node(
  name,
  units,
  n_layers = 1L,
  n_trees = 1L,
  tree_depth = 1L,
  threshold_init_beta = 1
)
}
\arguments{
\item{name}{name of the layer}

\item{units}{number of output dimensions, for regression and binary 
classification: 1, for mc-classification simply the number of classes}

\item{n_layers}{number of layers consisting of ODTs in NODE}

\item{n_trees}{number of trees per layer}

\item{tree_depth}{depth of tree per layer}

\item{threshold_init_beta}{parameter(s) for Beta-distribution used for initializing feature thresholds}
}
\value{
layer/model object
}
\description{
NODE/ODTs Layer
}
\examples{
n <- 1000
data_regr <- data.frame(matrix(rnorm(4 * n), c(n, 4)))
colnames(data_regr) <- c("x0", "x1", "x2", "x3")
y_regr <- rnorm(n) + data_regr$x0^2 + data_regr$x1 + 
  data_regr$x2*data_regr$x3 + data_regr$x2 + data_regr$x3
  
library(deepregression)

formula_node <- ~ node(x1, x2, x3, x0, n_trees = 2, n_layers = 2, tree_depth = 2)

mod_node_regr <- deepregression(
list_of_formulas = list(loc = formula_node, scale = ~ 1),
data = data_regr,
y = y_regr
)

if(!is.null(mod_node_regr)){
mod_node_regr \%>\% fit(epochs = 15, batch_size = 64, verbose = TRUE, 
  validation_split = 0.1, early_stopping = TRUE)
mod_node_regr \%>\% predict()
}

}
