% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{dm.bar}
\alias{dm.bar}
\title{Vector of sample average of each moment function
\eqn{(\bar{m}_n(\theta))}.}
\usage{
dm.bar(data, beta, t, hp, dmi.tens = NULL)
}
\arguments{
\item{data}{Data frame.}

\item{beta}{Vector of coefficients.}

\item{t}{Time point at which to compute the derivative of the moment
functions. Also allowed to
be a vector of time points (used in estimating the model under assumed time-
independent coefficients).}

\item{hp}{List of hyperparameters.}

\item{dmi.tens}{Tensor of derivative moment function evaluations. Can be used
to avoid some computation. Default is \code{dmi.tens = NULL}.}
}
\value{
A matrix containing the sample average of the partial derivatives of
the moment functions. Each row corresponds to a moment function, each column
corresponds to a coefficient.
}
\description{
This function computes the matrix containing the sample average
of the partial derivatives of the moment functions.
}
