% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci2p.R
\name{ci2p}
\alias{ci2p}
\title{ci2p}
\usage{
ci2p(
  est,
  lower,
  upper,
  log_transform = FALSE,
  conf = 0.95,
  qdist = stats::qnorm,
  pdist = stats::pnorm
)
}
\arguments{
\item{est}{estimated value}

\item{lower}{lower bound of the confidence level}

\item{upper}{upper bound of the confidence level}

\item{log_transform}{(default `FALSE`) flag indicating if a log
transformation as to apply to the data}

\item{conf}{(default `95\%`) confidence level}

\item{qdist}{(default `qnorm`) quantile function}

\item{pdist}{(default `pnorm`) distribution function}
}
\value{
a p-value
}
\description{
\code{ci2p} compute the p-value related with a provided confidence
interval. It considers a symmetric distribution (by default standard
normal).
}
\details{
Confidence level can be customize (by default 95%) and it is also
possible to apply a log transformation in case of proportions.
}
\examples{

ci2p(1.125, 0.634, 1.999, log_transform = TRUE)
ci2p(1.257, 1.126, 1.403, log_transform = TRUE)
}
