% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_process_did.R
\name{pre_process_did}
\alias{pre_process_did}
\title{Process \code{did} Function Arguments}
\usage{
pre_process_did(
  yname,
  tname,
  idname,
  gname,
  xformla = NULL,
  data,
  panel = TRUE,
  allow_unbalanced_panel,
  control_group = c("nevertreated", "notyettreated"),
  anticipation = 0,
  weightsname = NULL,
  alp = 0.05,
  bstrap = FALSE,
  cband = FALSE,
  biters = 1000,
  clustervars = NULL,
  est_method = "dr",
  base_period = "varying",
  print_details = TRUE,
  pl = FALSE,
  cores = 1,
  call = NULL
)
}
\arguments{
\item{yname}{The name of the outcome variable}

\item{tname}{The name of the column containing the time periods}

\item{idname}{The individual (cross-sectional unit) id name}

\item{gname}{The name of the variable in \code{data} that
contains the first period when a particular observation is treated.
This should be a positive number for all observations in treated groups.
It defines which "group" a unit belongs to.  It should be 0 for units
in the untreated group.}

\item{xformla}{A formula for the covariates to include in the
model.  It should be of the form \code{~ X1 + X2}.  Default
is NULL which is equivalent to \code{xformla=~1}.  This is
used to create a matrix of covariates which is then passed
to the 2x2 DID estimator chosen in \code{est_method}.}

\item{data}{The name of the data.frame that contains the data}

\item{panel}{Whether or not the data is a panel dataset.
The panel dataset should be provided in long format -- that
is, where each row corresponds to a unit observed at a
particular point in time.  The default is TRUE.  When
is using a panel dataset, the variable \code{idname} must
be set.  When \code{panel=FALSE}, the data is treated
as repeated cross sections.}

\item{allow_unbalanced_panel}{Whether or not function should
"balance" the panel with respect to time and id.  The default
values if \code{FALSE} which means that \code{\link[=att_gt]{att_gt()}} will drop
all units where data is not observed in all periods.
The advantage of this is that the computations are faster
(sometimes substantially).}

\item{control_group}{Which units to use the control group.
The default is "nevertreated" which sets the control group
to be the group of units that never participate in the
treatment.  This group does not change across groups or
time periods.  The other option is to set
\code{group="notyettreated"}.  In this case, the control group
is set to the group of units that have not yet participated
in the treatment in that time period.  This includes all
never treated units, but it includes additional units that
eventually participate in the treatment, but have not
participated yet.}

\item{anticipation}{The number of time periods before participating
in the treatment where units can anticipate participating in the
treatment and therefore it can affect their untreated potential outcomes}

\item{weightsname}{The name of the column containing the sampling weights.
If not set, all observations have same weight.}

\item{alp}{the significance level, default is 0.05}

\item{bstrap}{Boolean for whether or not to compute standard errors using
the multiplier bootstrap.  If standard errors are clustered, then one
must set \code{bstrap=TRUE}. Default is \code{TRUE} (in addition, cband
is also by default \code{TRUE} indicating that uniform confidence bands
will be returned.  If bstrap is \code{FALSE}, then analytical
standard errors are reported.}

\item{cband}{Boolean for whether or not to compute a uniform confidence
band that covers all of the group-time average treatment effects
with fixed probability \code{1-alp}.  In order to compute uniform confidence
bands, \code{bstrap} must also be set to \code{TRUE}.  The default is
\code{TRUE}.}

\item{biters}{The number of bootstrap iterations to use.  The default is 1000,
and this is only applicable if \code{bstrap=TRUE}.}

\item{clustervars}{A vector of variables names to cluster on.  At most, there
can be two variables (otherwise will throw an error) and one of these
must be the same as idname which allows for clustering at the individual
level. By default, we cluster at individual level (when \code{bstrap=TRUE}).}

\item{est_method}{the method to compute group-time average treatment effects.  The default is "dr" which uses the doubly robust
approach in the \code{DRDID} package.  Other built-in methods
include "ipw" for inverse probability weighting and "reg" for
first step regression estimators.  The user can also pass their
own function for estimating group time average treatment
effects.  This should be a function
\code{f(Y1,Y0,treat,covariates)} where \code{Y1} is an
\code{n} x \code{1} vector of outcomes in the post-treatment
outcomes, \code{Y0} is an \code{n} x \code{1} vector of
pre-treatment outcomes, \code{treat} is a vector indicating
whether or not an individual participates in the treatment,
and \code{covariates} is an \code{n} x \code{k} matrix of
covariates.  The function should return a list that includes
\code{ATT} (an estimated average treatment effect), and
\code{inf.func} (an \code{n} x \code{1} influence function).
The function can return other things as well, but these are
the only two that are required. \code{est_method} is only used
if covariates are included.}

\item{base_period}{Whether to use a "varying" base period or a
"universal" base period.  Either choice results in the same
post-treatment estimates of ATT(g,t)'s.  In pre-treatment
periods, using a varying base period amounts to computing a
pseudo-ATT in each treatment period by comparing the change
in outcomes for a particular group relative to its comparison
group in the pre-treatment periods (i.e., in pre-treatment
periods this setting computes changes from period t-1 to period
t, but repeatedly changes the value of t)

A universal base period fixes the base period to always be
(g-anticipation-1).  This does not compute
pseudo-ATT(g,t)'s in pre-treatment periods, but rather
reports average changes in outcomes from period t to
(g-anticipation-1) for a particular group relative to its comparison
group.  This is analogous to what is often reported in event
study regressions.

Using a varying base period results in an estimate of
ATT(g,t) being reported in the period immediately before
treatment.  Using a universal base period normalizes the
estimate in the period right before treatment (or earlier when
the user allows for anticipation) to be equal to 0, but one
extra estimate in an earlier period.}

\item{print_details}{Whether or not to show details/progress of computations.
Default is \code{FALSE}.}

\item{pl}{Whether or not to use parallel processing}

\item{cores}{The number of cores to use for parallel processing}

\item{call}{Function call to att_gt}
}
\value{
a \code{\link{DIDparams}} object
}
\description{
Function to process arguments passed to the main methods in the
\code{did} package as well as conducting some tests to make sure
data is in proper format / try to throw helpful error messages.
}
