% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_simulation.R
\name{kinsim_internal}
\alias{kinsim_internal}
\title{Simulate Kinship-Based Biometrically Informed Univariate Data}
\usage{
kinsim_internal(
  r = c(1, 0.5),
  c_rel = 1,
  npg = 100,
  npergroup = rep(npg, length(r)),
  mu = 0,
  ace = c(1, 1, 1),
  r_vector = NULL,
  c_vector = NULL,
  ...
)
}
\arguments{
\item{r}{Numeric vector. Levels of genetic relatedness for each group;
default is c(1, 0.5) representing MZ and DZ twins respectively.}

\item{npg}{Integer. Default sample size per group; default is 100.}

\item{npergroup}{Numeric vector. List of sample sizes by group;
default repeats \code{npg} for all groups in \code{r}.}

\item{mu}{Numeric. Mean value for the generated variable; default is 0.}

\item{ace}{Numeric vector. Variance components in order c(a, c, e) where
a = additive genetic, c = shared environment, e = non-shared environment;
default is c(1, 1, 1).}

\item{r_vector}{Numeric vector. Alternative specification method providing relatedness
coefficients for the entire sample; default is NULL.}

\item{...}{Additional arguments passed to other methods.}
}
\value{
A data frame with the following columns:
\describe{
  \item{id}{Unique identifier for each kinship pair}
  \item{A1}{Genetic component for first member of pair}
  \item{A2}{Genetic component for second member of pair}
  \item{C1}{Shared-environmental component for first member of pair}
  \item{C2}{Shared-environmental component for second member of pair}
  \item{E1}{Non-shared-environmental component for first member of pair}
  \item{E2}{Non-shared-environmental component for second member of pair}
  \item{y1}{Generated phenotype for first member of pair with mean \code{mu}}
  \item{y2}{Generated phenotype for second member of pair with mean \code{mu}}
  \item{r}{Level of genetic relatedness for the kinship pair}
}
}
\description{
Generates paired univariate data for kinship pairs with specified genetic relatedness,
following the classical ACE model (Additive genetic, Common environment, unique Environment).
}
\details{
This function simulates data according to the ACE model, where phenotypic variance
is decomposed into additive genetic (A), shared environmental (C), and non-shared
environmental (E) components. It can generate data for multiple kinship groups with
different levels of genetic relatedness (e.g., MZ twins, DZ twins, siblings).
}
\keyword{internal}
