% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icm_function.R
\name{compute_individual}
\alias{compute_individual}
\title{Computes Integrated Covariance Mahalanobis (ICM) distances for
individuals, in PCA-reduced space, against either global or batch-wise
references.}
\usage{
compute_individual(pc_data, ref = c("global", "batch"), batch_col)
}
\arguments{
\item{pc_data}{PCA-reduced data frame.}

\item{ref}{Reference type: "global" for global barycenter, "batch" for
batch-wise barycenters.}

\item{batch_col}{Name of the column representing batch or group.}
}
\value{
A data frame with Mahalanobis distances for each individual against
the specified reference.
}
\description{
Computes Integrated Covariance Mahalanobis (ICM) distances for
individuals, in PCA-reduced space, against either global or batch-wise
references.
}
