% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.dcca.R
\name{predict.dcca}
\alias{predict.dcca}
\title{Prediction for double-constrained correspondence analysis (dc-CA)}
\usage{
\method{predict}{dcca}(
  object,
  ...,
  type = c("envFromTraits", "traitsFromEnv", "response", "SNC", "CWM", "lc", "lc_traits"),
  rank = "full",
  newdata = NULL,
  weights = NULL,
  scaling = "symmetric"
)
}
\arguments{
\item{object}{return value of \code{\link{dc_CA}}.}

\item{...}{Other arguments passed to the function (currently ignored).}

\item{type}{type of prediction, \code{c("envFromTraits", "traitsFromEnv",
"response", "lc", "lc_traits")} for environmental values, values of traits, 
response (expected abundance) and constrained scores for sites and species. 
\code{"SNC"} is equivalent with \code{"envFromTraits"}.
\code{"CWM"} is equivalent with \code{"traitsFromEnv"}.}

\item{rank}{rank (number of axes to use). Default "full" for all axes 
(no rank-reduction).}

\item{newdata}{Data in which to look for variables with which to predict.
For \code{type = "envFromTraits" or "traitsFromEnv"} or 
\code{type = "lc_traits" or "lc"},
\code{newdata} is a data frame of trait and environmental values, respectively, 
which are used for the prediction or the calculation of scores.
If omitted, fitted values are generated (use \code{\link{fitted.dcca}} instead).
For \code{type = "response"}, newdata is a list of two data frames with 
trait and environmental values in this order, \emph{e.g.} 
\code{list(traits = dataTraits, env = dataEnv)}.}

\item{weights}{list of weights of species and of sites in \code{newdata} when
\code{type = "response"}, else ignored (default NULL
yielding equal species and site weights, both summing to 1). 
Example: weights = list(species = c(100, 1, 1), sites = c(1, 1, 1, 1)), in that
order, with traits of three new species in newdata[[1]] and 
environmental values (and levels of factors) of four new sites in newdata[[2]]. 
Species weights are scaled to a sum of one.}

\item{scaling}{numeric (1,2 or 3) or character \code{"sites", "species" or
"symmetric"}. Default: "symmetric". Either site- (1) or species- (2) related
scores are scaled by eigenvalues, and the other set of scores have
unit weighted mean square or with 3 both are scaled symmetrically 
to weighted mean squares equal to the square root of eigenvalues. Negative 
values are treated as the corresponding positive ones by \code{abs(scaling)}.}
}
\value{
a matrix with the predictions. The exact content of the matrix 
depends on the \code{type} of predictions that are being made.
}
\description{
Prediction of traits from environment, environment from traits and response 
from trait and environment data.
}
\details{
Variables that are in the model but not in \code{newdata} are set to their 
weighted means in the training data. Predictions are thus at the (weighted)
mean of the quantitative variables not included. Predictions with 
not-included factors are at the reference level (the first level of the 
factor).

For \code{type = "response"}, many of the predicted values may be negative, 
indicating expected absences (0) or small expected response values.

With \code{type = "traitsFromEnv"} and \code{newdata = NULL}, predict gives 
the  fitted mean traits, \emph{i.e.} the fitted community weighted means.
With \code{type = "envFromTraits"} and \code{newdata = NULL}, predict gives
the  fitted mean environment, \emph{i.e.} the fitted species niche centroids
(see \code{\link{fitted.dcca}}). See \code{fitted.dcca}.
}
\examples{
data("dune_trait_env")

# rownames are carried forward in results
rownames(dune_trait_env$comm) <- dune_trait_env$comm$Sites

mod <- dc_CA(formulaEnv = ~ A1 + Moist + Mag + Use + Condition(Manure),
             formulaTraits = ~ SLA + Height + LDMC + Condition(Seedmass) + Lifespan,
             response = dune_trait_env$comm[, -1],  # must delete "Sites"
             dataEnv = dune_trait_env$envir,
             dataTraits = dune_trait_env$traits,
             verbose = FALSE)

# Ten 'new' sites with a subset of the variables in mod 
# X_lot will be ignored as it is not part of the model
newEnv <- dune_trait_env$envir[1:10, c("A1", "Mag", "Manure", "X_lot")]
newEnv[2,"A1"] <- 3.0
rownames(newEnv) <- paste0("NewSite", 1:10)

pred.traits <- predict(mod, type = "traitsFromEnv", newdata = newEnv)
head(pred.traits)


# Eight 'new' species with a subset of traits that are included in the model 
# Variable "L" will be ignored as it is not in the model 
newTraits <- dune_trait_env$traits[1:8, c("Species", "SLA", "LDMC", "L")]
newTraits[3,"SLA"]<- 18 
rownames(newTraits) <- paste("Species",LETTERS[1:8] )# or another meaningful name.

pred.env <- predict(mod, type = "envFromTraits", newdata = newTraits)
head(pred.env)


pred.resp <- predict(mod, type = "response", newdata = list(newTraits, newEnv),
                     weights = list(species = rep(1:2, 4), sites = rep(1, 10)))
colSums(pred.resp) # about alternating 0.8 and 1.6 (reflecting the new species weights)
rowSums(pred.resp) # about equal rowsums
}
