% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractQuantilesDS1.R
\name{extractQuantilesDS1}
\alias{extractQuantilesDS1}
\title{Secure ranking of "V2BR" (vector to be ranked) across all sources
and use of these ranks to estimate global quantiles across all studies}
\usage{
extractQuantilesDS1(extract.quantiles, extract.summary.output.ranks.df)
}
\arguments{
\item{extract.quantiles}{one of a restricted set of character strings that
fix the set of quantile values for which the corresponding values across
all studies are to be estimated. For more details
see the associated document entitled "secure.global.ranking.docx", the
header for ds.ranksSecure and ds.extractQuantiles functions.
The value of this argument is set in choosing the value of the argument
<quantiles.for.estimation> in ds.ranksSecure.}

\item{extract.summary.output.ranks.df}{character string specifying optional
name for the data.frame written to the serverside on each data source that
contains 5 of the key output variables from the ranking procedure pertaining
to that particular data source. This data frame represents the key source of
information - including global ranks - that determines the values of V2BR
that are identified as corresponding to the particular set of quantiles to
be estimated as specified by the <quantiles.for.estimation> argument of
function ds.ranksSecure (and the <extract.quantiles> argument of
ds.extractQuantiles).}
}
\value{
as a first step in creating the vector of values of values of V2BR
that correspond to each quantile value, extractQuantilesDS1 identifies the
two closest quantile values across all studies that span each key quantile
value. These are saved as the data frame "closest.bounds.df" on the
clientside and then saved on the serverside by ds.dmtC2S into the data frame
"global.bounds.df". Also if the number of observations across all studies is
too small, and a  disclosure risk exists if the final.quantile.vector is made
available via the client, this function stops the processing and returns a
warning/error message.
}
\description{
identify the global values of V2BR (i.e. the values across all
studies) that relate to a set of quantiles to be evaluated.
}
\details{
Severside aggregate function called by ds.extractQuantiles via
ds.ranksSecure. As well as estimating the key values of V2BR that correspond
to the selected quantiles, this function also implements a disclosure control
trap. If the ratio of the total number of all observations across all studies
divided by the number of quantile values to be estimated is less than or
equal to nfilter.subset (which specifies the minimum size of a subset) the
process stops and an error message is returned suggesting that you might
try selecting a narrower range of quantiles with less quantile values to be
estimated as specified by the argument <quantiles.for.estimation> of the
function ds.ranksSecure. For more details about the cluster of functions that
collectively enable secure global ranking and estimation of global quantiles
see the associated document entitled "secure.global.ranking.docx"
}
\author{
Paul Burton 11th November, 2021
}
