% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranksSecureDS2.R
\name{ranksSecureDS2}
\alias{ranksSecureDS2}
\title{Secure ranking of "V2BR" (vector to be ranked) across all sources}
\usage{
ranksSecureDS2()
}
\value{
creates a new data frame sR5.df on the serverside containing
solely the real data and including key elements needed for next stage of the
ranking process. Most crucially these include "global.rank" and "ID.by.val"
sorted in ascending order of the magnitude of V2BR
}
\description{
Checks that the data frame produced in creating the initial
global ranks (ranks based on real and pseudo-data after the running of
blackBoxDS)has the correct dimensions and order as the serverside data frames
to which it will now be appended. If either the number of rows or the order
of the rows are inconsistent with the pre-existing data frames on the
serverside an error message is returned and the processing stops. Then
strips out the pseudo-data leaving solely the global ranks based just on
the real data
}
\details{
Severside assign function called by ds.ranksSecure. 
It works on the on the output created by serverside function ranksSecureDS1
and saved on the serverside in data frame sR4.df by ds.dmtC2S. Having
checked QA it strips out all rows corresponding to pseudo-data. The resultant
data frame contains the following vectors: (1) the fully encrypted V2BR
(after application of blackBoxDS);(2) "ID.by.val" the sequential
ID associated with the "combined real+pseudo data vector" sorted by
value (ascending); (3) "studyid", a vector consisting solely of value n in
the nth study; (4) "global.rank" the vector containing global ranks created by
the clientside code in ds.ranksSecure after ranksSecureDS1 is called and up
to the point where ds.dmtC2S sends sR4.df to the serverside. For more
details about the cluster of functions that collectively enable secure global
ranking and estimation of global quantiles see the associated document
entitled "secure.global.ranking.docx". Also see the header file
for ds.ranksSecure
}
\author{
Paul Burton 9th November, 2021
}
