% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleDS.R
\name{sampleDS}
\alias{sampleDS}
\title{random sampling and permuting of vectors, dataframes and matrices}
\usage{
sampleDS(
  x.transmit,
  size.transmit,
  replace.transmit = NULL,
  prob.transmit = NULL
)
}
\arguments{
\item{x.transmit}{Either a character string providing the name for the serverside
vector, matrix or data.frame to be sampled or permuted, or an integer/numeric
scalar (e.g. 923) indicating that one should create a new vector on the serverside
that is a randomly permuted sample of the vector 1:923. x.transmit is
fully specified by the [x] argument of ds.sample. For further details see 
help for ds.sample and native R help for sample().}

\item{size.transmit}{a numeric/integer scalar indicating the size of the sample to
be drawn. size.transmit is fully specified by the [size] argument of ds.sample.
For further details see help for ds.sample and native R help for sample().}

\item{replace.transmit}{a Boolean indicator (TRUE or FALSE) specifying whether the
sample should be drawn with or without replacement. Default is FALSE so
the sample is drawn without replacement. replace.transmit is
fully specified by the [replace] argument of ds.sample. For further details see 
help for ds.sample and native R help for sample().}

\item{prob.transmit}{a character string containing the name of a numeric vector
of probability weights on the serverside that is associated with each of the
elements of the vector to be sampled enabling the drawing of a sample
with some elements given higher probability of being drawn than others.
prob.transmit is fully specified by the [prob] argument of ds.sample. For further details see 
help for ds.sample and native R help for sample().}
}
\value{
the object specified by the <newobj> argument (or default name
'newobj.sample') which is written to the serverside. For further details see 
help for ds.sample and native R help for sample().
}
\description{
draws a pseudorandom sample from a vector, dataframe or matrix
on the serverside
or - as a special case - randomly permutes a vector, dataframe or matrix.
}
\details{
Serverside assign function sampleDS called by clientside
function ds.sample. Based on the native R function \code{sample()} but deals
slightly differently with data.frames and matrices. For further details see 
help for ds.sample and native R help for sample().
}
\author{
Paul Burton, for DataSHIELD Development Team, 15/4/2020
}
