% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relocate-rd.R, R/relocate.R
\name{relocate.duckplyr_df}
\alias{relocate.duckplyr_df}
\title{Change column order}
\usage{
\method{relocate}{duckplyr_df}(.data, ..., .before = NULL, .after = NULL)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Columns to move.}

\item{.before, .after}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Destination of
columns selected by \code{...}. Supplying neither will move columns to the
left-hand side; specifying both is an error.}
}
\description{
This is a method for the \code{\link[dplyr:relocate]{dplyr::relocate()}} generic.
See "Fallbacks" section for differences in implementation.
Use \code{relocate()} to change column positions,
using the same syntax as \code{select()} to make it easy to move blocks of columns at once.
}
\section{Fallbacks}{

There is no DuckDB translation in \code{relocate.duckplyr_df()}
\itemize{
\item with a selection that returns no columns.
}

These features fall back to \code{\link[dplyr:relocate]{dplyr::relocate()}}, see \code{vignette("fallback")} for details.
}

\examples{
df <- duckdb_tibble(a = 1, b = 1, c = 1, d = "a", e = "a", f = "a")
relocate(df, f)
}
\seealso{
\code{\link[dplyr:relocate]{dplyr::relocate()}}
}
