% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unary_operations.R
\name{ddbs_buffer}
\alias{ddbs_buffer}
\title{Creates a buffer around geometries}
\usage{
ddbs_buffer(
  conn,
  x,
  distance,
  name = NULL,
  crs = NULL,
  crs_column = "crs_duckspatial",
  overwrite = FALSE
)
}
\arguments{
\item{conn}{a connection object to a DuckDB database}

\item{x}{a table with a geometry column within the DuckDB database}

\item{distance}{a numeric value specifying the buffer distance. Units correspond to
the coordinate system of the geometry (e.g. degrees or meters)}

\item{name}{a character string of length one specifying the name of the table,
or a character string of length two specifying the schema and table names. If it's
NULL (the default), it will return the result as an \code{sf} object}

\item{crs}{the coordinates reference system of the data. Specify if the data
doesn't have a \code{crs_column}, and you know the CRS}

\item{crs_column}{a character string of length one specifying the column
storing the CRS (created automatically by \code{\link{ddbs_write_vector}}). Set
to NULL if absent}

\item{overwrite}{whether to overwrite the existing table if it exists. Ignored
when \code{name} is NULL}
}
\value{
an \code{sf} object or \code{TRUE} (invisibly) for table creation
}
\description{
Calculates the buffer of geometries from a DuckDB table using the spatial extension.
Returns the result as an \code{sf} object or creates a new table in the database.
}
\examples{
\dontrun{
## load packages
library(duckdb)
library(duckspatial)
library(sf)

## database setup
conn <- dbConnect(duckdb())
ddbs_install(conn)
ddbs_load(conn)

## read data
argentina_sf <- st_read(system.file("spatial/argentina.geojson", package = "duckspatial"))

## store in duckdb
ddbs_write_vector(conn, argentina_sf, "argentina")

## buffer
ddbs_buffer(conn, "argentina", distance = 1)
}
}
