% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_review.R
\name{mod_track}
\alias{mod_track}
\title{Data modification tracking}
\usage{
mod_track(before_tbl, after_tbl, id_var, plot = FALSE, vars2compare)
}
\arguments{
\item{before_tbl}{Data frame from before modifications were made.}

\item{after_tbl}{Data frame from after modifications were made.}

\item{id_var}{An unquoted expression which corresponds to a variable in both
\code{before_tbl} and \code{after_tbl} which identifies each row. Required.}

\item{plot}{Should a plot be returned instead of a table of results? Default:
\code{FALSE}.}

\item{vars2compare}{Character vectors of variable names to compare.}
}
\value{
Table containing row-level modification records or plot summarising
  modifications.
}
\description{
This function produces a table
where each row represents a value in a variable which is present in the
cleaned dataset and which has been modified. The identifier, original and
modified value, modification type, and variable names in the original and
modified datasets are recorded.
}
\examples{
# merge data as the example modification

require(magrittr)

 # example with one modification type (removal)
 # return table
  mod_track(example_data, strings_to_NA(example_data), patient_id)
 
 # return plot
  mod_track(example_data, strings_to_NA(example_data), patient_id, plot = TRUE)

 # example with multiple modification types (removal, substitution and addition)
example_data \%>\%
   strings_to_NA() \%>\%
   merge_cols(diabetes_type, diabetes) ->
   modded_data

# return table
mod_track(example_data, modded_data, patient_id, vars2compare = c("t_stage",
"diabetes_type_diabetes_merged" = "diabetes", "diabetes_type_diabetes_merged"
= "diabetes_type"), plot = FALSE)

# return plot
mod_track(example_data, modded_data, patient_id, vars2compare = c("t_stage",
"diabetes_type_diabetes_merged" = "diabetes", "diabetes_type_diabetes_merged"
= "diabetes_type"), plot = TRUE)
}
