% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div.r
\name{variance_adjusted_unifrac}
\alias{variance_adjusted_unifrac}
\title{Variance Adjusted UniFrac}
\usage{
variance_adjusted_unifrac(counts, tree = NULL, pairs = NULL, cpus = n_cpus())
}
\arguments{
\item{counts}{An OTU abundance matrix where each column is a sample, and
each row is an OTU. Any object coercible with \code{as.matrix()} can be
given here, as well as \code{phyloseq}, \code{rbiom}, \code{SummarizedExperiment},
and \code{TreeSummarizedExperiment} objects.}

\item{tree}{A \code{phylo}-class object representing the phylogenetic tree for
the OTUs in \code{counts}. The OTU identifiers given by \code{colnames(counts)}
must be present in \code{tree}. Can be omitted if a tree is embedded with
the \code{counts} object or as \code{attr(counts, 'tree')}.}

\item{pairs}{Which combinations of samples should distances be
calculated for? The default value (\code{NULL}) calculates all-vs-all.
Provide a numeric or logical vector specifying positions in the
distance matrix to calculate. See examples.}

\item{cpus}{How many parallel processing threads should be used. The
default, \code{n_cpus()}, will use all logical CPU cores.}
}
\value{
A \code{dist} object.
}
\description{
Variance Adjusted UniFrac beta diversity metric.
}
\section{Calculation}{


Given \eqn{n} branches with lengths \eqn{L} and a pair of samples'
abundances (\eqn{A} and \eqn{B}) on each of those branches:

\deqn{D = \displaystyle \frac{\sum_{i = 1}^{n} L_i\displaystyle \frac{|\frac{A_i}{A_T} - \frac{B_i}{B_T}|}{\sqrt{(A_i + B_i)(A_T + B_T - A_i - B_i)}} }{\sum_{i = 1}^{n} L_i\displaystyle \frac{\frac{A_i}{A_T} + \frac{B_i}{B_T}}{\sqrt{(A_i + B_i)(A_T + B_T - A_i - B_i)}} }}

See \code{vignette('unifrac')} for details and a worked example.
}

\examples{
    # Example counts matrix
    ex_counts
    
    # Variance Adjusted UniFrac distance matrix
    variance_adjusted_unifrac(ex_counts, tree = ex_tree)
    
    # Only calculate distances for A vs all.
    variance_adjusted_unifrac(ex_counts, tree = ex_tree, pairs = 1:3)
    
}
\references{
Chang Q, Luan Y, Sun F 2011.
Variance adjusted weighted UniFrac: a powerful beta diversity measure for comparing communities based on phylogeny.
BMC Bioinformatics, 12.
\doi{10.1186/1471-2105-12-118}
}
\seealso{
Other beta_diversity: 
\code{\link{bray_curtis}()},
\code{\link{canberra}()},
\code{\link{euclidean}()},
\code{\link{generalized_unifrac}()},
\code{\link{gower}()},
\code{\link{jaccard}()},
\code{\link{kulczynski}()},
\code{\link{manhattan}()},
\code{\link{unweighted_unifrac}()},
\code{\link{weighted_normalized_unifrac}()},
\code{\link{weighted_unifrac}()}
}
\concept{beta_diversity}
