% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dBdt.R
\name{dBdt}
\alias{dBdt}
\title{Dynamics from EcoSim}
\usage{
dBdt(
  Time,
  State,
  Pars,
  type_i,
  n_species,
  F_type = "integrated",
  what = "dBdt"
)
}
\arguments{
\item{Time}{not used}

\item{State}{vector of state variables to integrate}

\item{Pars}{list of parameters governing the ODE}

\item{type_i}{type for each taxon}

\item{n_species}{number of species}

\item{F_type}{whether to integrate catches along with biomass (\code{"integrated"})
or calculate catches from the Baranov catch equation applied to average
biomass (\code{"averaged"})}

\item{what}{what output to produce}
}
\value{
An object (list) of ranges. Elements include:
\describe{
\item{G_i}{Biomass growth per time}
\item{g_i}{Biomass growth per time per biomass}
\item{M2_i}{Consumptive mortality per time}
\item{m2_i}{Consumptive mortality per time per biomass}
\item{M_i}{Natural mortality per time}
\item{m_i}{Natural mortality per time per biomass (i.e., m2_i + m0_i)}
\item{Q_ij}{Consumption per time for prey (rows) by predator (columns)}
}
}
\description{
Compute system of differential equations representing EcoState dynamics
derived from EcoSim.
}
\details{
This function has syntax designed to match \code{pracma} solvers.
}
