% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_plot.R
\name{seq_plot}
\alias{seq_plot}
\title{Prepare an 'im' or 'SpatRaster' object for plotting with sequential color palette}
\usage{
seq_plot(input, cols, thresh_up = NULL, digits = 1)
}
\arguments{
\item{input}{An object of class 'im' or 'SpatRaster' from the \code{\link{perlrren}} function.}

\item{cols}{Character string of length three (3) specifying the colors for plotting: 1) presence, 2) neither, and 3) absence from the \code{\link{plot_obs}} function.}

\item{thresh_up}{Numeric. The upper value to concatenate the color key. The default (NULL) uses the maximum value from \code{input}.}

\item{digits}{Integer. The number of significant digits for the labels using the \code{\link[base]{round}} function (default is 1).}
}
\value{
An object of class 'list'. This is a named list with the following components:

\describe{
\item{\code{v}}{An object of class 'vector' for the estimated ecological niche values.}
\item{\code{cols}}{An object of class 'vector', returns diverging color palette values.}
\item{\code{breaks}}{An object of class 'vector', returns diverging color palette breaks.}
\item{\code{at}}{An object of class 'vector', returns legend breaks.}
\item{\code{labels}}{An object of class 'vector', returns legend labels.}
}
}
\description{
Internal function to convert 'im' object or 'SpatRaster' object to values readable by \code{\link[fields]{image.plot}} function within the \code{\link{plot_perturb}} function.
}
\keyword{internal}
