% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.sign.R
\name{esf-ergmTerm}
\alias{esf-ergmTerm}
\alias{InitErgmTerm.esf}
\title{Edgewise shared friends}
\usage{
# binary: esf(d, type="OTP", L.base=NULL, in_order=FALSE)
}
\arguments{
\item{d}{a vector of distinct integers}

\item{type}{A string indicating the type of shared partner or path to be considered for directed networks: `"OTP"` (default for directed), `"ITP"`, `"RTP"`, `"OSP"`, and `"ISP"`; has no effect for undirected. See the section below on Shared partner types for details.}

\item{base}{specify the base of the triad, either by '+' and '-' or 1 and -1}
}
\description{
This term adds one network statistic to the model for each element in `d` where the \eqn{i} th such statistic equals the number of edges in the network with exactly `d[i]` shared friends. For a directed network, multiple shared friend definitions are possible.
}
\note{
This term takes an additional term option (see
  [`options?ergm`][ergm-options]), `cache.sp`, controlling whether
  the implementation will cache the number of shared partners for
  each dyad in the network; this is usually enabled by default.
}
\section{Shared partner types}{
 While there is only one shared partner configuration in the undirected
  case, nine distinct configurations are possible for directed graphs, selected
  using the `type` argument. Currently, terms may be defined with respect to
  five of these configurations; they are defined here as follows (using
  terminology from Butts (2008) and the `relevent` package):
-  Outgoing Two-path (`"OTP"`): vertex \eqn{k} is an OTP shared partner of ordered
   pair \eqn{(i,j)} iff \eqn{i \to k \to j}{i->k->j}. Also known as "transitive
   shared partner".
- Incoming Two-path (`"ITP"`): vertex \eqn{k} is an ITP shared partner of ordered
   pair \eqn{(i,j)} iff \eqn{j \to k \to i}{j->k->i}. Also known as "cyclical shared
   partner"
- Reciprocated Two-path (`"RTP"`): vertex \eqn{k} is an RTP shared partner of ordered
   pair \eqn{(i,j)} iff \eqn{i \leftrightarrow k \leftrightarrow j}{i<->k<->j}.
- Outgoing Shared Partner (`"OSP"`): vertex \eqn{k} is an OSP shared partner of
   ordered pair \eqn{(i,j)} iff \eqn{i \to k, j \to k}{i->k, j->k}.
- Incoming Shared Partner (`"ISP"`): vertex \eqn{k} is an ISP shared partner of ordered
   pair \eqn{(i,j)} iff \eqn{k \to i, k \to j}{k->i, k->j}.
By default, outgoing two-paths (`"OTP"`) are calculated. Note that Robins et al. (2009)
  define closely related statistics to several of the above, using slightly different terminology.
}

\seealso{
[`ergmTerm`] for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "esf", "subsection")}
}
\concept{directed}
\concept{undirected}
