% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.operator.R,
%   R/InitWtErgmTerm.operator.R
\name{For-ergmTerm}
\alias{For-ergmTerm}
\alias{InitErgmTerm.For}
\alias{InitWtErgmTerm.For}
\title{A \code{\link{for}} operator for terms}
\usage{
# binary: For(...)

# valued: For(...)
}
\arguments{
\item{...}{in any order, \itemize{

\item one \emph{unnamed} one-sided \code{\link[=ergm]{ergm()}}-style formula with the
terms to be evaluated, containing one or more placeholders
\var{VAR} \emph{and}

\item one or more \emph{named} expressions of the form \code{\var{VAR}
  = \var{SEQ}} specifying the placeholder and its range. See
Details below.

}}
}
\description{
This operator evaluates the formula given to it,
substituting the specified loop counter variable with each
element in a sequence.
}
\details{
Placeholders are specified in the style of
\code{foreach::foreach()}, as \code{\var{VAR} = \var{SEQ}}. \var{VAR}
can be any valid \R variable name, and \var{SEQ} can be a vector,
a list, a function of one argument, or a one-sided formula.  The
vector or list will be used directly, whereas a function will be
called with the network as its argument to produce the list, and
the formula will be used analogously to \code{\link[purrr:as_mapper]{purrr::as_mapper()}}, its
RHS evaluated in an environment in which the network itself will
be accessible as \code{.} or \code{.nw}.

If more than one named expression is given, they will be expanded
as one would expect in a nested \code{\link{for}} loop: earlier expressions
will form the outer loops and later expressions the inner loops.
}
\examples{
#
# The following are equivalent ways to compute differential
# homophily.
#

data(sampson)
(groups <- sort(unique(samplike\%v\%"group"))) # Sorted list of groups.

# The "normal" way:
summary(samplike ~ nodematch("group", diff=TRUE))

# One element at a time, specifying a list:
summary(samplike ~ For(~nodematch("group", levels=., diff=TRUE),
                       . = groups))

# One element at a time, specifying a function that returns a list:
summary(samplike ~ For(~nodematch("group", levels=., diff=TRUE),
                       . = function(nw) sort(unique(nw\%v\%"group"))))

# One element at a time, specifying a formula whose RHS expression
# returns a list:
summary(samplike ~ For(~nodematch("group", levels=., diff=TRUE),
                       . = ~sort(unique(.\%v\%"group"))))

#
# Multiple iterators are possible, in any order. Here, absdiff() is
# being computed for each combination of attribute and power.
#

data(florentine)

# The "normal" way:
summary(flomarriage ~ absdiff("wealth", pow=1) + absdiff("priorates", pow=1) +
                      absdiff("wealth", pow=2) + absdiff("priorates", pow=2) +
                      absdiff("wealth", pow=3) + absdiff("priorates", pow=3))

# With a loop; note that the attribute (a) is being iterated within
# power (.):
summary(flomarriage ~ For(. = 1:3, a = c("wealth", "priorates"), ~absdiff(a, pow=.)))

}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "For", "subsection")}
}
\concept{operator}
