% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R, R/InitWtErgmTerm.R
\name{sociality-ergmTerm}
\alias{sociality-ergmTerm}
\alias{InitErgmTerm.sociality}
\alias{InitWtErgmTerm.sociality}
\title{Undirected degree}
\usage{
# binary: sociality(attr=NULL, base=1, levels=NULL, nodes=-1)

# valued: sociality(attr=NULL, base=1, levels=NULL, nodes=-1, form="sum")
}
\arguments{
\item{attr, levels}{this optional argument is deprecated and will be replaced with a more elegant implementation in a future release. In the meantime, it specifies a categorical vertex attribute (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details). If provided, this term only counts ties between nodes with the same value of the attribute (an actor-specific version of the \code{nodematch} term), restricted to be one of the values specified by (also deprecated) \code{levels} if \code{levels} is not \code{NULL} .}

\item{base}{deprecated}

\item{nodes}{By default, \code{nodes=-1} means that the statistic for the
first node will be omitted, but this argument may be changed to control
which statistics are included just as for the \code{nodes} argument of \code{sender} and
\code{receiver} terms.}

\item{form}{how to aggregate tie values in a valued ERGM: \code{"sum"}
(the default) for a statistic of the form \eqn{\sum_{i,j} x_{i,j}
  y_{i,j}}{sum[i,j] x[i,j]*y[i,j]}, where \eqn{y_{i,j}}{y[i,j]} is
the value of dyad \eqn{(i,j)} and \eqn{x_{i,j}}{x[i,j]} is the
term's covariate associated with it; and \code{"nonzero"} with the
edge considered to be present if its value is not 0. See
\code{\link{ergmTerm}} for more information.}
}
\description{
This term adds one network statistic for each node equal to the number of
ties of that node. For directed networks, see \code{sender} and
\code{receiver} .
}
\note{
The argument \code{base} is retained for backwards compatibility and may be
removed in a future version. When both \code{base} and \code{levels} are passed,
\code{levels} overrides \code{base}.

The argument \code{base} is retained for backwards compatibility and may be
removed in a future version. When both \code{base} and \code{nodes} are passed,
\code{nodes} overrides \code{base}.

This term can only be used with undirected networks.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "sociality", "subsection")}
}
\concept{categorical nodal attribute}
\concept{dyad-independent}
\concept{undirected}
