% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived_measures.R
\name{ebc_TPR}
\alias{ebc_TPR}
\alias{ebc_TNR}
\alias{ebc_PPV}
\alias{ebc_NPV}
\alias{ebc_FNR}
\alias{ebc_FPR}
\alias{ebc_FDR}
\alias{ebc_FOR}
\alias{ebc_ACC}
\alias{ebc_BACC}
\alias{ebc_F1}
\alias{ebc_PLR}
\alias{ebc_NLR}
\alias{ebc_DOR}
\title{Derived measures.}
\usage{
ebc_TPR(detected, true)

ebc_TNR(detected, true, all, m = length(all))

ebc_PPV(detected, true)

ebc_NPV(detected, true, all, m = length(all))

ebc_FNR(detected, true)

ebc_FPR(detected, true, all, m = length(all))

ebc_FDR(detected, true)

ebc_FOR(detected, true, all, m = length(all))

ebc_ACC(detected, true, all, m = length(all))

ebc_BACC(detected, true, all, m = length(all))

ebc_F1(detected, true)

ebc_PLR(detected, true, all, m = length(all))

ebc_NLR(detected, true, all, m = length(all))

ebc_DOR(detected, true, all, m = length(all))
}
\arguments{
\item{detected}{Vector of elements that are detected.}

\item{true}{Vector of element that are supposed to be detected.}

\item{all}{Vector of all elements.}

\item{m}{Total number of elements.}
}
\value{
A numeric.
}
\description{
Measures derived from confusion matrix.
}
\details{
See \code{\link{ebc_allmeasures}} for the description of the measures.
}
\examples{
ebc_TPR(detected = c("A", "C", "D"), true = c("A", "B", "C"))
ebc_ACC(detected = c("A", "C", "D"), true = c("A", "B", "C"),
        all = LETTERS[1:5])
}
\seealso{
\code{\link{ebc_TP}}, \code{\link{ebc_tidy}},
\code{\link{ebc_allmeasures}}
}
