% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dunif2.R
\name{ddunif2}
\alias{ddunif2}
\alias{sum_discrete_unif_cdf}
\alias{sum_discrete_unif_pmf}
\alias{sum_discrete_unif_rand}
\alias{sum_discrete_unif_quantile}
\alias{pdunif2}
\alias{qdunif2}
\alias{rdunif2}
\title{Sum of Two Independent Discrete Uniform Distributions}
\usage{
ddunif2(x, min = 1, max = 6)

pdunif2(q, min = 1, max = 6)

qdunif2(p, min = 1, max = 6)

rdunif2(n, min = 1, max = 6)

sum_discrete_unif_cdf(x, min = 1, max = 6)

sum_discrete_unif_pmf(q, min = 1, max = 6)

sum_discrete_unif_quantile(p, min = 1, max = 6)

sum_discrete_unif_rand(n, min = 1, max = 6)
}
\arguments{
\item{x, q}{numeric: vector of quantiles}

\item{min}{numeric: lower limit of the distribution (default: \code{1})}

\item{max}{numeric: upper limit of the distribution (default: \code{6})}

\item{p}{numeric: vector of probabilities}

\item{n}{numeric: number of observations. If \code{length(n)>1}, the length is taken to be the number required.}
}
\value{
A numeric vector with the same length as \code{x}.
}
\description{
Probability mass function, distribution function, quantile function and random generation
for the sum of two independent discrete uniform distributions.
}
\examples{
ddunif2(1:13)
pdunif2(1:13)
qdunif2((0:4)/4)
rdunif2(10)
}
