% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proptest_data.R
\name{proptest_data}
\alias{proptest_data}
\alias{prop_binomtest_data}
\alias{dbinomtest}
\title{Binomial Test Data Creation}
\usage{
proptest_data(
  size = 10:100,
  prob = seq(0.05, 0.45, by = 0.05),
  reject = TRUE,
  alternative = c("two.sided", "less", "greater"),
  alpha = c(0.01, 0.05, 0.1),
  norm.approx = NA,
  maxit = 1000
)

prop_binomtest_data(
  size = 10:100,
  prob = seq(0.05, 0.45, by = 0.05),
  reject = TRUE,
  alternative = c("two.sided", "less", "greater"),
  alpha = c(0.01, 0.05, 0.1),
  norm.approx = NA,
  maxit = 1000
)

dbinomtest(
  size = 10:100,
  prob = seq(0.05, 0.45, by = 0.05),
  reject = TRUE,
  alternative = c("two.sided", "less", "greater"),
  alpha = c(0.01, 0.05, 0.1),
  norm.approx = NA,
  maxit = 1000
)
}
\arguments{
\item{size}{numeric: vector of sample sizes (default \code{10:100})}

\item{prob}{numeric: vector of probabilities for the hypothetical proportion \eqn{\pi_0} (default \code{=seq(0.05, 0.45, by=0.05)})}

\item{reject}{logical: should \code{x} generate a lead for the rejection of the null hypothesis (default \code{TRUE}), if equals \code{NA} then this will be ignored}

\item{alternative}{character: a character string specifying the alternative hypothesis, must be one of \code{two.sided} (default), \code{greater} or \code{less}}

\item{alpha}{numeric: vector of significance levels (default \code{c(0.01, 0.05, 0.1)})}

\item{norm.approx}{logical: should a normal approximation be possible (\eqn{size*prob*(1-prob)>9})}

\item{maxit}{integer: maximal numbers of trials to find a solution (default \code{1000})}
}
\value{
A list with the components:
\itemize{
\item \code{pi0} hypothetical proportion
\item \code{x} counts of successes in the sample
\item \code{n} sample size
\item \code{alpha} significance level
\item \code{alternative} specifying the alternative hypothesis (either \code{two.sided}, \code{greater} or \code{less})
}
}
\description{
Creates data for a binomial test based on the properties for the test.
}
\examples{
proptest_data()
}
