% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique_elem.R
\name{unique_elem}
\alias{unique_elem}
\title{Unique Elements}
\usage{
unique_elem(x, elem = NULL)
}
\arguments{
\item{x}{a \code{hyperloop} object}

\item{elem}{character: list elements which are used to check if \code{hyperloop} results are identical}
}
\value{
A reduced \code{hyperloop} object
}
\description{
Deletes all elements from a \code{hyperloop} object that are identical.
Since the result in each run can be a list itself, only specific list elements can be used for comparison.
}
\examples{
x <- rnorm(100)
# 6 results: 3 different mu's, 2 var.equals
hl <- hyperloop(t.test, x=x, mu=list(-1, 0, 1), var.equal=list(TRUE, FALSE))
# reduction to 3 elements since var.equal does not play any role
length(unique_elem(hl))    
# reduction to 1 element since the mean of x always the same
length(unique_elem(hl, "estimate"))
}
