% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLquantile.R
\name{plotLquantile}
\alias{plotLquantile}
\title{Plot quantiles of distributions fitted with L-moments}
\usage{
plotLquantile(
  dlf,
  nbest = 5,
  selection = NULL,
  order = FALSE,
  rows = NULL,
  heights = stats::quantile(par("usr")[3:4], 0.2),
  distcols = dlfplot$distcols,
  linargs = NULL,
  ...
)
}
\arguments{
\item{dlf}{List as returned by \code{\link{distLquantile}}, containing the
elements \code{dat, parameter, gof, datname, quant}}

\item{nbest, selection, order}{Distributions to be plotted, see \code{\link{plotLfit}}}

\item{rows}{Rowname(s) of \code{dlf$quant} that should be drawn instead of
the selection / nbest highest ranking distribution functions.
'GPD*' will select all the gpd fits. heights and distcols must then
accordingly have at least 13 elements (or will be recycled).
DEFAULT: NULL}

\item{heights}{Coordinates of quantile line ends, recycled if necessary.
DEFAULT: 20\% of plot height.}

\item{distcols}{Color for each distribution added with \code{\link{lines}}.
DEFAULT: dlfplot$distcols}

\item{linargs}{Arguments passed to \code{\link{lines}}. DEFAULT: NULL}

\item{\dots}{Further arguments passed to \code{\link{plotLfit}}}
}
\value{
invisible dlf object, see \code{\link{printL}}
}
\description{
Plot quantiles of distributions fitted with L-moments
}
\examples{
# See distLquantile

}
\seealso{
\code{\link{distLquantile}}, \code{\link{plotLfit}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Dec 2016
}
\keyword{distribution}
\keyword{hplot}
