% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-detransient.R
\name{detransient_pupil}
\alias{detransient_pupil}
\title{Internal function to remove transient artifacts from pupil data}
\usage{
detransient_pupil(x, prev_op, n, mad_thresh)
}
\arguments{
\item{x}{A data frame containing pupil data with columns \code{time_secs} and
the previous operation's pupil column}

\item{prev_op}{The name of the previous operation's pupil column}

\item{n}{The constant used to compute the median absolute deviation (MAD)
threshold. Defaults to \code{16}}

\item{mad_thresh}{The threshold used to identify transient artifacts.
Defaults to \code{NULL}}
}
\value{
A numeric vector of the same length as the input data with transient
artifacts removed (set to NA)
}
\description{
This function implements transient artifact removal by
identifying and removing samples that exceed a speed-based threshold.
The threshold is computed based on the constant \code{n}, which defaults to
the value \code{16}.

This function is called by the exposed wrapper \code{\link[=detransient]{detransient()}}.
}
\details{
The function works by:
\itemize{
\item Calculating the speed of pupil changes using finite differences
\item Identifying samples that exceed a speed-based threshold
\item Removing these samples from the pupil data
}
}
\keyword{internal}
