% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-downsample.R
\name{downsample_pupil}
\alias{downsample_pupil}
\title{Internal function to downsample pupil data}
\usage{
downsample_pupil(x, prev_op, target_fs, plot_freqz, current_fs, rp, rs)
}
\arguments{
\item{x}{A data frame containing pupil data with columns \code{time_secs} and
the previous operation's pupil column}

\item{prev_op}{The name of the previous operation's pupil column}

\item{target_fs}{The target sampling frequency in Hz after downsampling}

\item{plot_freqz}{A flag to indicate whether to display the filter frequency
response. Defaults to \code{FALSE}}

\item{current_fs}{The current sampling frequency in Hz. Defaults to \code{NULL}}

\item{rp}{Passband ripple in dB. Defaults to \code{1}}

\item{rs}{Stopband attenuation in dB. Defaults to \code{35}}
}
\value{
A list containing the downsampled data and the decimated sample rate
}
\description{
This function downsamples pupil data by applying an
anti-aliasing filter before decimation. Unlike binning, downsampling
preserves the original temporal dynamics without averaging within bins.

This function is called by the exposed wrapper \code{\link[=downsample]{downsample()}}.
}
\keyword{internal}
