# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title AccountDirectories
#' @description AccountDirectories Class
#' @format An \code{R6Class} generator object
#' @field accounts  list( character ) [optional]
#'
#' @field directories  list( character ) [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
AccountDirectories <- R6::R6Class(
  'AccountDirectories',
  public = list(
    `accounts` = NULL,
    `directories` = NULL,
    initialize = function(`accounts`=NULL, `directories`=NULL, ...){
      local.optional.var <- list(...)
      if (!is.null(`accounts`)) {
        stopifnot(is.vector(`accounts`), length(`accounts`) != 0)
        sapply(`accounts`, function(x) stopifnot(is.character(x)))
        self$`accounts` <- `accounts`
      }
      if (!is.null(`directories`)) {
        stopifnot(is.vector(`directories`), length(`directories`) != 0)
        sapply(`directories`, function(x) stopifnot(is.character(x)))
        self$`directories` <- `directories`
      }
    },
    toJSON = function() {
      AccountDirectoriesObject <- list()
      if (!is.null(self$`accounts`)) {
        AccountDirectoriesObject[['accounts']] <-
          self$`accounts`
      }
      if (!is.null(self$`directories`)) {
        AccountDirectoriesObject[['directories']] <-
          self$`directories`
      }

      AccountDirectoriesObject
    },
    fromJSON = function(AccountDirectoriesJson) {
      AccountDirectoriesObject <- jsonlite::fromJSON(AccountDirectoriesJson)
      if (!is.null(AccountDirectoriesObject$`accounts`)) {
        self$`accounts` <- ApiClient$new()$deserializeObj(AccountDirectoriesObject$`accounts`, "array[character]", loadNamespace("factset.analyticsapi.engines"))
      }
      if (!is.null(AccountDirectoriesObject$`directories`)) {
        self$`directories` <- ApiClient$new()$deserializeObj(AccountDirectoriesObject$`directories`, "array[character]", loadNamespace("factset.analyticsapi.engines"))
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`accounts`)) {
        sprintf(
        '"accounts":
           [%s]
        ',
        paste(unlist(lapply(self$`accounts`, function(x) paste0('"', x, '"'))), collapse=",")
        )},
        if (!is.null(self$`directories`)) {
        sprintf(
        '"directories":
           [%s]
        ',
        paste(unlist(lapply(self$`directories`, function(x) paste0('"', x, '"'))), collapse=",")
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(AccountDirectoriesJson) {
      AccountDirectoriesObject <- jsonlite::fromJSON(AccountDirectoriesJson)
      self$`accounts` <- ApiClient$new()$deserializeObj(AccountDirectoriesObject$`accounts`, "array[character]", loadNamespace("factset.analyticsapi.engines"))
      self$`directories` <- ApiClient$new()$deserializeObj(AccountDirectoriesObject$`directories`, "array[character]", loadNamespace("factset.analyticsapi.engines"))
      self
    }
  )
)
