# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title CalculationStatusSummary
#' @description CalculationStatusSummary Class
#' @format An \code{R6Class} generator object
#' @field status  character [optional]
#'
#' @field points  integer [optional]
#'
#' @field requestTime  character [optional]
#'
#' @field lastPollTime  character [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
CalculationStatusSummary <- R6::R6Class(
  'CalculationStatusSummary',
  public = list(
    `status` = NULL,
    `points` = NULL,
    `requestTime` = NULL,
    `lastPollTime` = NULL,
    initialize = function(`status`=NULL, `points`=NULL, `requestTime`=NULL, `lastPollTime`=NULL, ...){
      local.optional.var <- list(...)
      if (!is.null(`status`)) {
        stopifnot(is.character(`status`), length(`status`) == 1)
        self$`status` <- `status`
      }
      if (!is.null(`points`)) {
        stopifnot(is.numeric(`points`), length(`points`) == 1)
        self$`points` <- `points`
      }
      if (!is.null(`requestTime`)) {
        stopifnot(is.character(`requestTime`), length(`requestTime`) == 1)
        self$`requestTime` <- `requestTime`
      }
      if (!is.null(`lastPollTime`)) {
        stopifnot(is.character(`lastPollTime`), length(`lastPollTime`) == 1)
        self$`lastPollTime` <- `lastPollTime`
      }
    },
    toJSON = function() {
      CalculationStatusSummaryObject <- list()
      if (!is.null(self$`status`)) {
        CalculationStatusSummaryObject[['status']] <-
          self$`status`
      }
      if (!is.null(self$`points`)) {
        CalculationStatusSummaryObject[['points']] <-
          self$`points`
      }
      if (!is.null(self$`requestTime`)) {
        CalculationStatusSummaryObject[['requestTime']] <-
          self$`requestTime`
      }
      if (!is.null(self$`lastPollTime`)) {
        CalculationStatusSummaryObject[['lastPollTime']] <-
          self$`lastPollTime`
      }

      CalculationStatusSummaryObject
    },
    fromJSON = function(CalculationStatusSummaryJson) {
      CalculationStatusSummaryObject <- jsonlite::fromJSON(CalculationStatusSummaryJson)
      if (!is.null(CalculationStatusSummaryObject$`status`)) {
        self$`status` <- CalculationStatusSummaryObject$`status`
      }
      if (!is.null(CalculationStatusSummaryObject$`points`)) {
        self$`points` <- CalculationStatusSummaryObject$`points`
      }
      if (!is.null(CalculationStatusSummaryObject$`requestTime`)) {
        self$`requestTime` <- CalculationStatusSummaryObject$`requestTime`
      }
      if (!is.null(CalculationStatusSummaryObject$`lastPollTime`)) {
        self$`lastPollTime` <- CalculationStatusSummaryObject$`lastPollTime`
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`status`)) {
        sprintf(
        '"status":
          "%s"
                ',
        self$`status`
        )},
        if (!is.null(self$`points`)) {
        sprintf(
        '"points":
          %d
                ',
        self$`points`
        )},
        if (!is.null(self$`requestTime`)) {
        sprintf(
        '"requestTime":
          "%s"
                ',
        self$`requestTime`
        )},
        if (!is.null(self$`lastPollTime`)) {
        sprintf(
        '"lastPollTime":
          "%s"
                ',
        self$`lastPollTime`
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(CalculationStatusSummaryJson) {
      CalculationStatusSummaryObject <- jsonlite::fromJSON(CalculationStatusSummaryJson)
      self$`status` <- CalculationStatusSummaryObject$`status`
      self$`points` <- CalculationStatusSummaryObject$`points`
      self$`requestTime` <- CalculationStatusSummaryObject$`requestTime`
      self$`lastPollTime` <- CalculationStatusSummaryObject$`lastPollTime`
      self
    }
  )
)
