# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title Dates operations
#' @description factset.analyticsapi.engines.Dates
#' @format An \code{R6Class} generator object
#' @field apiClient Handles the client-server communication.
#'
#' @section Methods:
#' \describe{
#' \strong{ ConvertPADatesToAbsoluteFormat } \emph{ Convert PA dates to absolute format }
#' This endpoint converts the given start and end dates to yyyymmdd format for a PA calculation.
#'
#' \itemize{
#' \item \emph{ @param } enddate character
#' \item \emph{ @param } componentid character
#' \item \emph{ @param } account character
#' \item \emph{ @param } startdate character
#' \item \emph{ @returnType } \link{DateParametersSummary} \cr
#'
#' \item On encountering errors, an error of subclass ApiException will be thrown.
#'
#' \item status code : 200 | Expected response, returns the converted dates in yyyymmdd format.
#'
#' \item return type : DateParametersSummary 
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 400 | Invalid query parameter or value is provided.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 401 | Missing or invalid authentication.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 403 | User is forbidden with current credentials
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 404 | Document or account not found.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 406 | Unsupported Accept header. Header needs to be set to application/json.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 503 | Request timed out. Retry the request in sometime.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' }
#'
#' \strong{ ConvertVaultDatesToAbsoluteFormat } \emph{ Convert Vault dates to absolute format }
#' This endpoint converts the given start and end dates to yyyymmdd format for a Vault calculation.
#'
#' \itemize{
#' \item \emph{ @param } enddate character
#' \item \emph{ @param } componentid character
#' \item \emph{ @param } account character
#' \item \emph{ @param } startdate character
#' \item \emph{ @returnType } \link{DateParametersSummary} \cr
#'
#' \item On encountering errors, an error of subclass ApiException will be thrown.
#'
#' \item status code : 200 | Expected response, returns the converted dates in yyyymmdd format.
#'
#' \item return type : DateParametersSummary 
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 400 | Invalid query parameter or value is provided.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 401 | Missing or invalid authentication.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 403 | User is forbidden with current credentials
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 404 | vault Document or account not found.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 406 | Unsupported Accept header. Header needs to be set to application/json.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 503 | Request timed out. Retry the request in sometime.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' }
#'
#' }
#'
#'
#' @examples
#' \dontrun{
#' ####################  ConvertPADatesToAbsoluteFormat  ####################
#'
#' library(factset.analyticsapi.engines)
#' var.enddate <- 'enddate_example' # character | End Date
#' var.componentid <- 'componentid_example' # character | Component Id
#' var.account <- 'account_example' # character | Account
#' var.startdate <- 'startdate_example' # character | Start Date
#'
#' #Convert PA dates to absolute format
#' api.instance <- DatesApi$new()
#'
#' #Configure HTTP basic authorization: Basic
#' # provide your username in the user-serial format
#' api.instance$apiClient$username <- '<user-serial>'; 
#' # provide your api key generated using the developer portal
#' api.instance$apiClient$password <- '<api_key>';
#'
#'result <- tryCatch(
#'             api.instance$ConvertPADatesToAbsoluteFormat(var.enddate, var.componentid, var.account, startdate=var.startdate),
#'             ApiException = function(ex) ex 
#'          )
#' # In case of error, print the error object 
#' if(!is.null(result$ApiException)) {
#'   cat(result$ApiException$toString())
#' } else {
#' # deserialized response object
#' response.object <- result$content
#' # response headers
#' response.headers <- result$response$headers
#' # response status code
#' response.status.code <- result$response$status_code
#' }
#'
#'
#' ####################  ConvertVaultDatesToAbsoluteFormat  ####################
#'
#' library(factset.analyticsapi.engines)
#' var.enddate <- 'enddate_example' # character | End Date
#' var.componentid <- 'componentid_example' # character | Vault Component Id
#' var.account <- 'account_example' # character | Account
#' var.startdate <- 'startdate_example' # character | Start Date
#'
#' #Convert Vault dates to absolute format
#' api.instance <- DatesApi$new()
#'
#' #Configure HTTP basic authorization: Basic
#' # provide your username in the user-serial format
#' api.instance$apiClient$username <- '<user-serial>'; 
#' # provide your api key generated using the developer portal
#' api.instance$apiClient$password <- '<api_key>';
#'
#'result <- tryCatch(
#'             api.instance$ConvertVaultDatesToAbsoluteFormat(var.enddate, var.componentid, var.account, startdate=var.startdate),
#'             ApiException = function(ex) ex 
#'          )
#' # In case of error, print the error object 
#' if(!is.null(result$ApiException)) {
#'   cat(result$ApiException$toString())
#' } else {
#' # deserialized response object
#' response.object <- result$content
#' # response headers
#' response.headers <- result$response$headers
#' # response status code
#' response.status.code <- result$response$status_code
#' }
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom caTools base64encode
#' @importFrom rlang abort
#' @export
DatesApi <- R6::R6Class(
  'DatesApi',
  public = list(
    apiClient = NULL,
    initialize = function(apiClient){
      if (!missing(apiClient)) {
        self$apiClient <- apiClient
      }
      else {
        self$apiClient <- ApiClient$new()
      }
    },
    ConvertPADatesToAbsoluteFormat = function(enddate, componentid, account, startdate=NULL, ...){
      apiResponse <- self$ConvertPADatesToAbsoluteFormatWithHttpInfo(enddate, componentid, account, startdate, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    ConvertPADatesToAbsoluteFormatWithHttpInfo = function(enddate, componentid, account, startdate=NULL, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`enddate`)) {
        rlang::abort(message = "Missing required parameter `enddate`.", .subclass = "ApiException", ApiException = ApiException$new(status = 0, reason = "Missing required parameter `enddate`."))
      }

      if (missing(`componentid`)) {
        rlang::abort(message = "Missing required parameter `componentid`.", .subclass = "ApiException", ApiException = ApiException$new(status = 0, reason = "Missing required parameter `componentid`."))
      }

      if (missing(`account`)) {
        rlang::abort(message = "Missing required parameter `account`.", .subclass = "ApiException", ApiException = ApiException$new(status = 0, reason = "Missing required parameter `account`."))
      }

      queryParams['startdate'] <- startdate

      queryParams['enddate'] <- enddate

      queryParams['componentid'] <- componentid

      queryParams['account'] <- account

      urlPath <- "/analytics/lookups/v2/engines/pa/dates"
      # HTTP basic auth
      headerParams['Authorization'] <- paste("Basic", caTools::base64encode(paste(self$apiClient$username, self$apiClient$password, sep=":")), sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "DateParametersSummary", loadNamespace("factset.analyticsapi.engines")),
          error = function(e){
             rlang::abort(message = "Failed to deserialize response", .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- paste("Server returned " , httr::status_code(resp) , " response status code.")
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api client exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api server exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      }
    },
    ConvertVaultDatesToAbsoluteFormat = function(enddate, componentid, account, startdate=NULL, ...){
      apiResponse <- self$ConvertVaultDatesToAbsoluteFormatWithHttpInfo(enddate, componentid, account, startdate, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    ConvertVaultDatesToAbsoluteFormatWithHttpInfo = function(enddate, componentid, account, startdate=NULL, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`enddate`)) {
        rlang::abort(message = "Missing required parameter `enddate`.", .subclass = "ApiException", ApiException = ApiException$new(status = 0, reason = "Missing required parameter `enddate`."))
      }

      if (missing(`componentid`)) {
        rlang::abort(message = "Missing required parameter `componentid`.", .subclass = "ApiException", ApiException = ApiException$new(status = 0, reason = "Missing required parameter `componentid`."))
      }

      if (missing(`account`)) {
        rlang::abort(message = "Missing required parameter `account`.", .subclass = "ApiException", ApiException = ApiException$new(status = 0, reason = "Missing required parameter `account`."))
      }

      queryParams['startdate'] <- startdate

      queryParams['enddate'] <- enddate

      queryParams['componentid'] <- componentid

      queryParams['account'] <- account

      urlPath <- "/analytics/lookups/v2/engines/vault/dates"
      # HTTP basic auth
      headerParams['Authorization'] <- paste("Basic", caTools::base64encode(paste(self$apiClient$username, self$apiClient$password, sep=":")), sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "DateParametersSummary", loadNamespace("factset.analyticsapi.engines")),
          error = function(e){
             rlang::abort(message = "Failed to deserialize response", .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- paste("Server returned " , httr::status_code(resp) , " response status code.")
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api client exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api server exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      }
    }
  )
)
