% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpSplines.r
\name{interpSplines,GVector,GRaster-method}
\alias{interpSplines,GVector,GRaster-method}
\alias{interpSplines}
\title{Interpolate values at points to a GRaster using splines}
\usage{
\S4method{interpSplines}{GVector,GRaster}(
  x,
  y,
  field,
  method = "bilinear",
  lambda = NULL,
  solver = "Cholesky",
  xlength = NULL,
  ylength = NULL,
  interpolate = TRUE,
  verbose = is.null(lambda)
)
}
\arguments{
\item{x}{A "points" \code{GVector}.}

\item{y}{A \code{GRaster}: The output will have the same extent and resolution as this raster.}

\item{field}{Character or integer or numeric integer: Name or index of the column in \code{x} with values to interpolate. If \code{NULL} and if \code{x} is a 3-dimensional "points" \code{GVector}, then the interpolation will act on the z-coordinate of each point.}

\item{method}{Character: The method to use for interpolation can be either \code{"bilinear"} (default) or \code{"bicubic"}. Partial matching is used.}

\item{lambda}{Either \code{NULL} (default) or numeric value > 0: The Tykhonov regularization parameter. If \code{NULL}, cross-validation will be used to determine the optimal parameter value. Cross-validation can take quite a while. If you use cross-validation, the output will either be a \code{GRaster} or a \code{data.frame}, depending on the value of \code{interpolate}.}

\item{solver}{Character: Type of solver to use. Can be either of \code{"Cholesky"} or \code{"cg"}. Partial matching is used and case is ignored.}

\item{xlength, ylength}{Either \code{NULL} (default), or numeric > 0: Length of the spline step in the x- and y-directions. If \code{NULL}, these will be set to 4 times the length of the extent in the respective direction.}

\item{interpolate}{Logical: If \code{TRUE} (default), then create a \code{GRaster} with interpolated values. If \code{FALSE}, return a table with \code{lambda} values from cross-validation. This argument is ignored if \code{lambda} is a numeric value.}

\item{verbose}{Logical: if \code{TRUE}, display progress.}
}
\value{
Output depends on values of \code{lambda} and \code{interpolate}:
\itemize{
\item \code{lambda} is \code{NULL} and \code{interpolate} is \code{TRUE}: A \code{GRaster} with an attribute named \code{lambdas}. This is a \code{data.frame} with values of \code{lambda} that were assessed, plus \code{mean} (mean residual value) and \code{rms} (root mean square error). You can see the table using \code{attr(output_raster, "lambdas", exact = TRUE)}.
\item \code{lambda} is \code{NULL} and \code{interpolate} is \code{FALSE}: A \code{data.frame} with values of \code{lambdas} that were assessed, plus \code{mean} (mean residual value) and \code{rms} (root mean square error). You can see the table using \code{attr(output_raster, "lambdas", exact = TRUE)}.
\item \code{lambda} is a number (\code{interpolate} is ignored): A \code{GRaster}.
}
}
\description{
This function interpolates values in the data table of a "points" \code{GVector} to a \code{GRaster} using splines with Tykhonov regularization to avoid overfitting.
}
\details{
If you receive the error, "No data within this subregion. Consider increasing spline step values, try increasing the values of \code{xlength} and \code{ylength}.

If cross-validation takes too long, or other warnings/errors persist, you can randomly subsample \code{x} to ~100 points to get an optimum value of \code{lambda} (using \code{interpolate = FALSE}), then use this value in the same function again without cross-validation (setting \code{lambda} equal to this value and \code{interpolate = TRUE}).
}
\seealso{
\code{\link[=interpIDW]{interpIDW()}}, \code{\link[=fillNAs]{fillNAs()}}, \strong{GRASS} tool \code{v.surf.bspline} (see \code{grassHelp("v.surf.bspline")})
}
