% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_models.R
\name{fastml_compute_holdout_results}
\alias{fastml_compute_holdout_results}
\title{Evaluate Models Function}
\usage{
fastml_compute_holdout_results(
  models,
  train_data,
  test_data,
  label,
  start_col = NULL,
  time_col = NULL,
  status_col = NULL,
  task,
  metric = NULL,
  event_class,
  eval_times = NULL,
  bootstrap_ci = TRUE,
  bootstrap_samples = 500,
  bootstrap_seed = 1234,
  at_risk_threshold = 0.1,
  precomputed_predictions = NULL,
  summaryFunction = NULL
)
}
\arguments{
\item{models}{A list of trained model objects.}

\item{train_data}{Preprocessed training data frame.}

\item{test_data}{Preprocessed test data frame.}

\item{label}{Name of the target variable. For survival analysis this should
be a character vector of length two giving the names of the time and status
columns.}

\item{start_col}{Optional string. The name of the column specifying the
start time in counting process (e.g., `(start, stop, event)`) survival
data. Only used when \code{task = "survival"}.}

\item{time_col}{String. The name of the column specifying the event or
censoring time (the "stop" time in counting process data). Only used
when \code{task = "survival"}.}

\item{status_col}{String. The name of the column specifying the event
status (e.g., 0 for censored, 1 for event). Only used when
\code{task = "survival"}.}

\item{task}{Type of task: "classification", "regression", or "survival".}

\item{metric}{The performance metric to optimize (e.g., "accuracy", "rmse").}

\item{event_class}{A single string. Either "first" or "second" to specify which level of truth to consider as the "event".}

\item{eval_times}{Optional numeric vector of evaluation horizons for survival
metrics. Passed through to \code{process_model}.}

\item{bootstrap_ci}{Logical indicating whether bootstrap confidence intervals
should be computed for the evaluation metrics.}

\item{bootstrap_samples}{Number of bootstrap resamples used when
\code{bootstrap_ci = TRUE}.}

\item{bootstrap_seed}{Optional integer seed for the bootstrap procedure used
in metric estimation.}

\item{at_risk_threshold}{Minimum proportion of subjects that must remain at
risk to define \eqn{t_{max}} when computing survival metrics such as the
integrated Brier score.}

\item{precomputed_predictions}{Optional data frame or nested list of
previously generated predictions (per algorithm/engine) to reuse instead
of recomputing. This is mainly used when combining results across engines.}

\item{summaryFunction}{Optional custom classification metric function passed
through to \code{process_model} for holdout evaluation.}
}
\value{
A list with two elements:
  \describe{
    \item{performance}{A named list of performance metric tibbles for each model.}
    \item{predictions}{A named list of data frames with columns including truth, predictions, and probabilities per model.}
  }
}
\description{
Evaluates the trained models on the test data and computes performance metrics.
}
