% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{candidates}
\alias{candidates}
\title{Candidates Master metadata}
\format{
A data frame with 4648 rows and 15 columns, providing information
for each candidate:
\describe{
\item{cand_id}{A 9-character alpha-numeric code assigned to a candidate by the FEC, which remains
the same across election cycles if running for the same office}
\item{cand_name}{Candidate name}
\item{cand_pty_affiliation}{The political party affiliation reported by the candidate}
\item{cand_election_yr}{Candidate's Election Year}
\item{cand_office_st}{Candidate's state}
\item{cand_office}{Candidate office with designation: H = House, P = President, S = Senate}
\item{cand_office_district}{Congressional district number: Congressional at-large 00, Senate 00, Presidential 00}
\item{cand_ici}{Incumbent challenger status with designation: C = Challenger, I = Incumbent, O = Open Seat}
\item{cand_status}{Candidate status with designation: C = Statutory candidate, F = Statutory candidate for future election,
N = Not yet a statutory candidate, P = Statutory candidate in prior cycle}
\item{cand_pcc}{ID of the candidate's principal campaign committee assigned by FEC}
\item{cand_st1}{Candidate's Mailing address - street 1}
\item{cand_st2}{Candidate's Mailing address - street 2}
\item{cand_city}{Candidate's Mailing address - city}
\item{cand_st}{Candidate's Mailing address - state}
\item{cand_zip}{Candidate's Mailing address - ZIP code}
}
}
\source{
\url{https://www.fec.gov/campaign-finance-data/candidate-master-file-description/}, updated 2020-03-02
}
\usage{
candidates
}
\description{
Basic information for each candidate.
}
\keyword{datasets}
