% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{felt_add_map_layers_url}
\alias{felt_add_map_layers_url}
\title{Add Layers to Existing Map from URL}
\usage{
felt_add_map_layers_url(map_id, url, name = NULL)
}
\arguments{
\item{map_id}{map identifier from url, from \verb{https://felt.com/map/Readable-Name-map_id}}

\item{url}{Link to layer to include}

\item{name}{Name of the layer}
}
\value{
a \link[tibble:tibble]{tibble::tibble} for the created layer
}
\description{
See \href{https://feltmaps.notion.site/b26d739e80184127872faa923b55d232?pvs=25#3e37f06bc38c4971b435fbff2f4da6cb}{Felt "Upload Anything" documentation}
for detailed examples of potential URLs.
}
\examples{
\dontshow{if (has_felt_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# split the URL for length reasons
url <- paste0(
'https://www.rocklandgis.com/portal/sharing/rest/',
'content/items/73fc78cb0fb04580b4788937fe5ee697/data'
)
layer <- felt_add_map_layers_url(
    map_id = 'Rockland-2024-Districts-TBI8sDkmQjuK2GX9CSiHiUA',
    url = url,
    name = 'Parks')
layer
# and delete the new layer
felt_delete_map_layer(map_id = 'TBI8sDkmQjuK2GX9CSiHiUA',  layer_id = layer$id)
\dontshow{\}) # examplesIf}
}
\concept{edits}
