% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-mks-test.R
\name{plot_mks_test}
\alias{plot_mks_test}
\title{Plot Mann–Kendall–Sneyers (MKS) Test Results}
\usage{
plot_mks_test(results, show_line = TRUE, ...)
}
\arguments{
\item{results}{A list generated by \code{\link[=eda_mks_test]{eda_mks_test()}}.}

\item{show_line}{If \code{TRUE} (default), draw a fitted line through the data.}

\item{...}{Optional named arguments: 'title', 'top_xlabel', 'top_ylabel',
'bottom_xlabel' and 'bottom_ylabel'.}
}
\value{
A \code{patchwork} object with two \code{ggplot2} panels stacked vertically.
}
\description{
Constructs a two‐panel visualization of the MKS test. The upper panel plots the
normalized progressive and regressive Mann–Kendall S‐statistics over time, with
dashed confidence bounds and potential trend‐change points. The lower panel
contains the annual maximum series data with the change points highlighted.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
years <- seq(from = 1901, to = 2000)
results <- eda_mks_test(data, years)
plot_mks_test(results)

}
\seealso{
\code{\link[=eda_mks_test]{eda_mks_test()}}
}
