% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Triangle.R
\name{fitTriBin}
\alias{fitTriBin}
\title{Fitting the Triangular Binomial Distribution when binomial random variable, frequency and mode
value are given}
\usage{
fitTriBin(x,obs.freq,mode)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{obs.freq}{vector of frequencies.}

\item{mode}{single value for mode.}
}
\value{
The output of \code{fitTriBin} gives the class format \code{fitTB} and \code{fit} consisting a list

\code{bin.ran.var} binomial random variables.

\code{obs.freq} corresponding observed frequencies.

\code{exp.freq} corresponding expected frequencies.

\code{statistic} chi-squared test statistics value.

\code{df} degree of freedom.

\code{p.value} probability value by chi-squared test statistic.

\code{fitTB} fitted probability values of \code{dTriBin}.

\code{NegLL} Negative Log Likelihood value.

\code{mode} estimated mode value.

\code{AIC} AIC value.

\code{over.dis.para} over dispersion value.

\code{call} the inputs of the function.

Methods \code{summary}, \code{print}, \code{AIC}, \code{residuals} and \code{fitted}
can be used to extract specific outputs.
}
\description{
The function will fit the Triangular Binomial distribution when random variables, corresponding
frequencies and mode parameter are given. It will provide the expected frequencies, chi-squared
test statistics value, p value, degree of freedom and over dispersion value so that it can be
seen if this distribution fits the data.
}
\details{
\deqn{0 < mode=c < 1}
\deqn{x = 0,1,2,...}
\deqn{0 < mode < 1}
\deqn{obs.freq \ge 0}

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further.
}
\examples{
No.D.D <- 0:7      #assigning the random variables
Obs.fre.1 <- c(47,54,43,40,40,41,39,95)  #assigning the corresponding frequencies

modeTriBin <- EstMLETriBin(No.D.D,Obs.fre.1)$mode  #assigning the extracted the mode value

#fitting when the random variable,frequencies,mode value are given.
results <- fitTriBin(No.D.D,Obs.fre.1,modeTriBin)
results

#extract AIC value
AIC(results)

#extract fitted values
fitted(results)

}
\references{
\insertRef{horsnell1957economical}{fitODBOD}
\insertRef{karlis2008polygonal}{fitODBOD}
\insertRef{okagbue2014using}{fitODBOD}
}
