% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.frailtyDesign.R
\name{summary.frailtyDesign}
\alias{summary.frailtyDesign}
\title{Summarize a 'frailtyDesign' object.}
\usage{
\method{summary}{frailtyDesign}(object, digits = 2, ...)
}
\arguments{
\item{object}{an object of class 'frailtyDesign' (output from one of the
*.power or *.ssize functions).}

\item{digits}{number of decimals to print for numeric fields. Default is 2.}

\item{\dots}{other unused arguments.}
}
\description{
Summarize a 'frailtyDesign' object.
}
\examples{
est.ex <- SFM.power(
  Groups = 400, ni = 3, ni.type = "max", FUP = 6, Acc.Dur = 0.5, median.H0 = 1.5,
  beta.HA = log(0.7), theta = 0.5, cens.par = c(3, 10), cens.type = "Unif", data.type = "rec_event"
)

summary(est.ex)

}
\seealso{
\code{\link{frailtyDesign}}
}
\keyword{methods}
