% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search-vars.R
\name{search_vars}
\alias{search_vars}
\title{Search variables in a .scss file}
\usage{
search_vars(file)
}
\arguments{
\item{file}{File path in which to search for variables.}
}
\value{
A \code{data.frame} with 2 columns: \code{"variable"} and \code{"value"}.
}
\description{
Search variables in a .scss file
}
\examples{
# Create a scss file with some variables
tmp_scss_file <- tempfile(fileext = ".scss")
writeLines("//Some variables\n $color: red;\n $body-bg: #FFF;", tmp_scss_file)

# Search for variables
search_vars(tmp_scss_file)


# Clean up
unlink(tmp_scss_file)
}
